/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.container.web.jetty;

import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.fabric3.pojo.reflection.Injector;
import org.fabric3.spi.ObjectCreationException;
import org.mortbay.jetty.servlet.ServletHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectingServletHandler
extends ServletHandler {
    private Map<String, List<Injector<?>>> injectorMappings;

    public InjectingServletHandler(Map<String, List<Injector<?>>> injectorMappings) {
        this.injectorMappings = injectorMappings;
    }

    public Servlet customizeServlet(Servlet servlet) throws Exception {
        this.inject(servlet);
        return servlet;
    }

    public Filter customizeFilter(Filter filter) throws Exception {
        this.inject(filter);
        return filter;
    }

    private void inject(Object instance) throws ObjectCreationException {
        List<Injector<?>> injectors = this.injectorMappings.get(instance.getClass().getName());
        if (injectors != null) {
            for (Injector<?> injector : injectors) {
                injector.inject(instance);
            }
        }
    }
}

