/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.container.web.jetty;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.fabric3.api.annotation.Monitor;
import org.fabric3.container.web.jetty.InjectingServletHandler;
import org.fabric3.container.web.jetty.InjectingSessionListener;
import org.fabric3.container.web.jetty.WebApplicationActivatorMonitor;
import org.fabric3.container.web.jetty.WorkContextHandler;
import org.fabric3.container.web.spi.WebApplicationActivationException;
import org.fabric3.container.web.spi.WebApplicationActivator;
import org.fabric3.jetty.JettyService;
import org.fabric3.pojo.reflection.Injector;
import org.fabric3.spi.ObjectCreationException;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.fabric3.spi.contribution.ContributionUriResolver;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.jetty.webapp.WebAppContext;
import org.osoa.sca.ComponentContext;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyWebApplicationActivator
implements WebApplicationActivator {
    private JettyService jettyService;
    private ClassLoaderRegistry classLoaderRegistry;
    private ContributionUriResolver contributionUriResolver;
    private WebApplicationActivatorMonitor monitor;
    private Map<URI, Holder> mappings;

    public JettyWebApplicationActivator(@Reference JettyService jettyService, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference ContributionUriResolver contributionUriResolver, @Monitor WebApplicationActivatorMonitor monitor) {
        this.jettyService = jettyService;
        this.monitor = monitor;
        this.classLoaderRegistry = classLoaderRegistry;
        this.contributionUriResolver = contributionUriResolver;
        this.mappings = new ConcurrentHashMap<URI, Holder>();
    }

    public ClassLoader getWebComponentClassLoader(URI componentId) {
        return this.classLoaderRegistry.getClassLoader(componentId);
    }

    public ServletContext activate(String contextPath, URI uri, URI parentClassLoaderId, Map<String, List<Injector<?>>> injectors, ComponentContext componentContext) throws WebApplicationActivationException {
        if (this.mappings.containsKey(uri)) {
            throw new WebApplicationActivationException("Mapping already exists: " + uri.toString());
        }
        try {
            URL resolved = this.contributionUriResolver.resolve(uri);
            ClassLoader parentClassLoader = this.createParentClassLoader(parentClassLoaderId, uri);
            WebAppContext context = this.createWebAppContext("/" + contextPath, injectors, resolved, parentClassLoader);
            this.jettyService.registerHandler((Handler)context);
            context.start();
            List sessionInjectors = (List)List.class.cast(injectors.get("fabric3.sessionContext"));
            InjectingSessionListener listener = new InjectingSessionListener(sessionInjectors);
            context.getSessionHandler().addEventListener((EventListener)((Object)listener));
            ContextHandler.SContext servletContext = context.getServletContext();
            this.injectServletContext((ServletContext)servletContext, injectors);
            Holder holder = new Holder(contextPath, context);
            this.mappings.put(uri, holder);
            this.monitor.activated(holder.getContextPath());
            return servletContext;
        }
        catch (Exception e) {
            throw new WebApplicationActivationException((Throwable)e);
        }
    }

    public void deactivate(URI uri) throws WebApplicationActivationException {
        Holder holder = this.mappings.remove(uri);
        if (holder == null) {
            throw new WebApplicationActivationException("Mapping does not exist: " + uri.toString());
        }
        WebAppContext context = holder.getContext();
        this.jettyService.getServer().removeLifeCycle((LifeCycle)context);
        try {
            context.stop();
        }
        catch (Exception e) {
            throw new WebApplicationActivationException((Throwable)e);
        }
        this.monitor.deactivated(holder.getContextPath());
    }

    private ClassLoader createParentClassLoader(URI parentClassLoaderId, URI id) {
        ClassLoader cl = this.classLoaderRegistry.getClassLoader(parentClassLoaderId);
        MultiParentClassLoader parentClassLoader = new MultiParentClassLoader(id, cl);
        parentClassLoader.addParent(this.getClass().getClassLoader());
        return parentClassLoader;
    }

    private WebAppContext createWebAppContext(String contextPath, Map<String, List<Injector<?>>> injectors, URL resolved, ClassLoader parentClassLoader) throws IOException, URISyntaxException {
        WebAppContext context = new WebAppContext(resolved.toExternalForm(), contextPath);
        context.setParentLoaderPriority(true);
        context.setServletHandler((ServletHandler)new InjectingServletHandler(injectors));
        WebAppClassLoader webAppClassLoader = new WebAppClassLoader(parentClassLoader, context);
        context.setClassLoader((ClassLoader)webAppClassLoader);
        context.addHandler((Handler)new WorkContextHandler());
        return context;
    }

    private void injectServletContext(ServletContext servletContext, Map<String, List<Injector<?>>> injectors) throws ObjectCreationException {
        List<Injector<?>> list = injectors.get("fabric3.servletContext");
        if (list == null) {
            return;
        }
        for (Injector<?> injector : list) {
            injector.inject((Object)servletContext);
        }
    }

    private static class Holder {
        private String contextPath;
        private WebAppContext context;

        private Holder(String contextPath, WebAppContext context) {
            this.contextPath = contextPath;
            this.context = context;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public WebAppContext getContext() {
            return this.context;
        }
    }
}

