/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.container.web.jetty;

import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.fabric3.spi.objectfactory.Injector;
import org.fabric3.spi.objectfactory.ObjectCreationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectingDecorator
implements ServletContextHandler.Decorator {
    private Map<String, List<Injector<?>>> injectorMappings;

    public InjectingDecorator(Map<String, List<Injector<?>>> injectorMappings) {
        this.injectorMappings = injectorMappings;
    }

    public <T extends Filter> T decorateFilterInstance(T filter) throws ServletException {
        this.inject(filter);
        return filter;
    }

    public <T extends Servlet> T decorateServletInstance(T servlet) throws ServletException {
        this.inject(servlet);
        return servlet;
    }

    public <T extends EventListener> T decorateListenerInstance(T listener) throws ServletException {
        this.inject(listener);
        return listener;
    }

    public void decorateFilterHolder(FilterHolder filter) throws ServletException {
        this.inject(filter);
    }

    public void decorateServletHolder(ServletHolder servlet) throws ServletException {
        this.inject(servlet);
    }

    public void destroyServletInstance(Servlet s) {
    }

    public void destroyFilterInstance(Filter f) {
    }

    public void destroyListenerInstance(EventListener f) {
    }

    private void inject(Object instance) throws ServletException {
        List<Injector<?>> injectors = this.injectorMappings.get(instance.getClass().getName());
        if (injectors != null) {
            for (Injector<?> injector : injectors) {
                try {
                    injector.inject(instance);
                }
                catch (ObjectCreationException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }
    }
}

