/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.container.web.jetty;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.container.web.jetty.InjectingDecorator;
import org.fabric3.container.web.jetty.ManagedWebAppContext;
import org.fabric3.container.web.jetty.WebApplicationActivatorMonitor;
import org.fabric3.container.web.spi.InjectingSessionListener;
import org.fabric3.container.web.spi.WebApplicationActivationException;
import org.fabric3.container.web.spi.WebApplicationActivator;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.fabric3.spi.contribution.ContributionResolver;
import org.fabric3.spi.management.ManagementException;
import org.fabric3.spi.management.ManagementService;
import org.fabric3.spi.objectfactory.Injector;
import org.fabric3.spi.objectfactory.ObjectCreationException;
import org.fabric3.transport.jetty.JettyService;
import org.oasisopen.sca.ComponentContext;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyWebApplicationActivator
implements WebApplicationActivator {
    private JettyService jettyService;
    private ClassLoaderRegistry classLoaderRegistry;
    private ContributionResolver resolver;
    private ManagementService managementService;
    private WebApplicationActivatorMonitor monitor;
    private Map<URI, Holder> mappings;

    public JettyWebApplicationActivator(@Reference JettyService jettyService, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference ContributionResolver resolver, @Reference ManagementService managementService, @Monitor WebApplicationActivatorMonitor monitor) {
        this.jettyService = jettyService;
        this.classLoaderRegistry = classLoaderRegistry;
        this.resolver = resolver;
        this.managementService = managementService;
        this.monitor = monitor;
        this.mappings = new ConcurrentHashMap<URI, Holder>();
    }

    @Destroy
    public void destroy() {
        for (Holder holder : this.mappings.values()) {
            try {
                this.remove(holder.getContext());
            }
            catch (ManagementException e) {
                this.monitor.error("Error removing managed bean for context: " + holder.getContext().getDisplayName(), e);
            }
        }
    }

    public ClassLoader getWebComponentClassLoader(URI componentId) {
        return this.classLoaderRegistry.getClassLoader(componentId);
    }

    public ServletContext activate(String contextPath, final URI uri, URI parentClassLoaderId, final Map<String, List<Injector<?>>> injectors, ComponentContext componentContext) throws WebApplicationActivationException {
        if (this.mappings.containsKey(uri)) {
            throw new WebApplicationActivationException("Mapping already exists: " + uri.toString());
        }
        try {
            URL resolved = this.resolver.resolve(uri);
            ClassLoader parentClassLoader = this.createParentClassLoader(parentClassLoaderId, uri);
            final WebAppContext context = this.createWebAppContext("/" + contextPath, injectors, resolved, parentClassLoader);
            this.jettyService.registerHandler((Handler)context);
            context.addEventListener((EventListener)new ServletContextListener(){

                public void contextInitialized(ServletContextEvent sce) {
                    List sessionInjectors = (List)List.class.cast(injectors.get("fabric3.sessionContext"));
                    InjectingSessionListener listener = new InjectingSessionListener(sessionInjectors);
                    context.getSessionHandler().addEventListener((EventListener)listener);
                    ContextHandler.Context servletContext = context.getServletContext();
                    try {
                        JettyWebApplicationActivator.this.injectServletContext((ServletContext)servletContext, injectors);
                    }
                    catch (ObjectCreationException e) {
                        JettyWebApplicationActivator.this.monitor.error("Error initializing web component: " + uri, e);
                    }
                }

                public void contextDestroyed(ServletContextEvent sce) {
                    context.getSessionHandler().clearEventListeners();
                }
            });
            context.start();
            ContextHandler.Context servletContext = context.getServletContext();
            Holder holder = new Holder(contextPath, context);
            this.mappings.put(uri, holder);
            this.export(context);
            this.monitor.activated(holder.getContextPath());
            return servletContext;
        }
        catch (Exception e) {
            throw new WebApplicationActivationException((Throwable)e);
        }
    }

    public void deactivate(URI uri) throws WebApplicationActivationException {
        Holder holder = this.mappings.remove(uri);
        if (holder == null) {
            throw new WebApplicationActivationException("Mapping does not exist: " + uri.toString());
        }
        WebAppContext context = holder.getContext();
        this.jettyService.getServer().removeBean((Object)context);
        try {
            this.remove(context);
            context.stop();
        }
        catch (Exception e) {
            throw new WebApplicationActivationException((Throwable)e);
        }
        context.setClassLoader(null);
        this.jettyService.removeHandler((Handler)context);
        this.monitor.deactivated(holder.getContextPath());
    }

    private ClassLoader createParentClassLoader(URI parentClassLoaderId, URI id) {
        ClassLoader cl = this.classLoaderRegistry.getClassLoader(parentClassLoaderId);
        MultiParentClassLoader parentClassLoader = new MultiParentClassLoader(id, cl);
        parentClassLoader.addParent(this.getClass().getClassLoader());
        return parentClassLoader;
    }

    private WebAppContext createWebAppContext(String contextPath, Map<String, List<Injector<?>>> injectors, URL resolved, ClassLoader parentClassLoader) throws IOException {
        ManagedWebAppContext context = new ManagedWebAppContext(resolved.toExternalForm(), contextPath);
        context.setParentLoaderPriority(true);
        InjectingDecorator decorator = new InjectingDecorator(injectors);
        context.addDecorator(decorator);
        WebAppClassLoader webAppClassLoader = new WebAppClassLoader(parentClassLoader, (WebAppClassLoader.Context)context);
        context.setClassLoader((ClassLoader)webAppClassLoader);
        return context;
    }

    private void injectServletContext(ServletContext servletContext, Map<String, List<Injector<?>>> injectors) throws ObjectCreationException {
        List<Injector<?>> list = injectors.get("fabric3.servletContext");
        if (list == null) {
            return;
        }
        for (Injector<?> injector : list) {
            injector.inject((Object)servletContext);
        }
    }

    private void export(WebAppContext context) throws ManagementException {
        String displayName = context.getDisplayName();
        if (displayName == null) {
            displayName = UUID.randomUUID().toString();
        }
        String webAppName = this.encodeName(displayName);
        this.managementService.export(webAppName, "webapps/" + webAppName, "web application", (Object)context);
        ServletHandler handler = context.getServletHandler();
        for (ServletHolder servletHolder : handler.getServlets()) {
            String group = "webapps/" + webAppName + "/servlets";
            this.managementService.export(webAppName + "/" + servletHolder.getName(), group, "web application", (Object)servletHolder);
        }
    }

    private void remove(WebAppContext context) throws ManagementException {
        String displayName = context.getDisplayName();
        if (displayName == null) {
            displayName = context.toString();
        }
        String webAppName = this.encodeName(displayName);
        this.managementService.remove(webAppName, "webapps/" + webAppName);
        ServletHandler handler = context.getServletHandler();
        for (ServletHolder servletHolder : handler.getServlets()) {
            String group = "webapps/" + webAppName + "/servlets";
            this.managementService.remove(webAppName + "/" + servletHolder.getName(), group);
        }
    }

    private String encodeName(String name) {
        return name.toLowerCase().replace('\n', ' ');
    }

    private static class Holder {
        private String contextPath;
        private WebAppContext context;

        private Holder(String contextPath, WebAppContext context) {
            this.contextPath = contextPath;
            this.context = context;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public WebAppContext getContext() {
            return this.context;
        }
    }
}

