/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.container.web.jetty;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.webapp.WebAppContext;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.container.web.spi.WebRequestTunnel;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.invocation.WorkContextCache;

@Management
public class ManagedWebAppContext
extends WebAppContext {
    public ManagedWebAppContext(String webAppDir, String contextPath) {
        super(webAppDir, contextPath);
    }

    @ManagementOperation(description="The web app name")
    public String getDisplayName() {
        return super.getDisplayName();
    }

    @ManagementOperation(description="The web app context path")
    public String getContextPath() {
        return super.getContextPath();
    }

    @ManagementOperation(description="If web app is available")
    public boolean isAvailable() {
        return super.isAvailable();
    }

    @ManagementOperation(description="The web app state")
    public String getState() {
        return super.getState();
    }

    @ManagementOperation(description="Start the web app")
    public void startWebApp() throws Exception {
        super.start();
    }

    @ManagementOperation(description="Stop the web app")
    public void stopWebApp() throws Exception {
        super.stop();
    }

    public String[] getVirtualHosts() {
        return super.getVirtualHosts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        WorkContext workContext = WorkContextCache.getAndResetThreadWorkContext();
        try {
            WebRequestTunnel.setRequest((HttpServletRequest)request);
            super.doHandle(target, baseRequest, request, response);
        }
        finally {
            WebRequestTunnel.setRequest(null);
            workContext.reset();
        }
    }
}

