/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jaxb.runtime.impl;

import java.net.URI;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.fabric3.jaxb.provision.AbstractTransformingInterceptorDefinition;
import org.fabric3.jaxb.runtime.impl.TransformingBuilderException;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.interceptor.InterceptorBuilder;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.wire.Interceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransformingInterceptorBuilder<T extends AbstractTransformingInterceptorDefinition, I extends Interceptor>
implements InterceptorBuilder<T, I> {
    private ClassLoaderRegistry classLoaderRegistry;

    public AbstractTransformingInterceptorBuilder(ClassLoaderRegistry classLoaderRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public I build(T definition) throws BuilderException {
        URI classLoaderId = definition.getClassLoaderId();
        ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(classLoaderId);
        QName dataType = definition.getDataType();
        assert (classLoader != null);
        try {
            Set classNames = definition.getClassNames();
            JAXBContext context = this.getJAXBContext(classLoader, classNames);
            return this.build(dataType, context, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new TransformingBuilderException(e);
        }
        catch (JAXBException e) {
            throw new TransformingBuilderException(e);
        }
    }

    protected abstract I build(QName var1, JAXBContext var2, ClassLoader var3) throws TransformingBuilderException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getJAXBContext(ClassLoader classLoader, Set<String> classNames) throws JAXBException, ClassNotFoundException {
        Class[] classes = new Class[classNames.size()];
        int i = 0;
        for (String className : classNames) {
            classes[i++] = this.classLoaderRegistry.loadClass(classLoader, className);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classes);
            return jAXBContext;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

