/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jaxb.runtime.impl;

import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.transform.PullTransformer;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformingInterceptor<S, T>
implements Interceptor {
    private Interceptor next;
    private final ClassLoader classLoader;
    private final PullTransformer<S, T> inTransformer;
    private final PullTransformer<T, S> outTransformer;

    public TransformingInterceptor(PullTransformer<S, T> inTransformer, PullTransformer<T, S> outTransformer, ClassLoader classLoader) {
        this.inTransformer = inTransformer;
        this.outTransformer = outTransformer;
        this.classLoader = classLoader;
    }

    public Interceptor getNext() {
        return this.next;
    }

    public void setNext(Interceptor next) {
        this.next = next;
    }

    public Message invoke(Message message) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Message response;
            Object result;
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Object payload = message.getBody();
            if (payload != null && payload.getClass().isArray()) {
                Object[] params = (Object[])message.getBody();
                if (params.length > 0) {
                    Object[] transformed = new Object[params.length];
                    for (int i = 0; i < params.length; ++i) {
                        Object param = params[i];
                        transformed[i] = this.inTransformer.transform(param, null);
                        message.setBody((Object)transformed);
                    }
                }
            } else if (payload != null) {
                Object transformed = this.inTransformer.transform(payload, null);
                message.setBody((Object)new Object[]{transformed});
            }
            if ((result = (response = this.next.invoke(message)).getBody()) != null) {
                Object transformed = this.outTransformer.transform(result, null);
                if (response.isFault()) {
                    response.setBodyWithFault(transformed);
                } else {
                    response.setBody(transformed);
                }
            }
            Message message2 = response;
            return message2;
        }
        catch (TransformationException e) {
            throw new InvocationRuntimeException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

