/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.featureset;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.fabric3.featureset.Dependency;
import org.fabric3.featureset.FeatureSet;
import org.xml.sax.SAXException;

public class Fabric3FeatureSetMojo
extends AbstractMojo {
    protected MavenProject project;
    protected Dependency[] extensions;
    protected File outputDirectory;
    protected Dependency[] includes;
    protected Dependency[] shared;
    public ArtifactResolver resolver;
    public ArtifactRepository localRepository;
    public List<String> remoteRepositories;
    public ArtifactFactory artifactFactory;
    private FeatureSet featureSet = new FeatureSet();

    public void execute() throws MojoExecutionException, MojoFailureException {
        String fileName = this.project.getArtifactId() + "-" + this.project.getVersion() + ".xml";
        File file = new File(this.outputDirectory, fileName);
        try {
            this.outputDirectory.mkdirs();
            file.createNewFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (this.extensions == null && this.includes == null) {
            throw new MojoExecutionException("Extensions or includes should be specified");
        }
        this.processExtensions();
        this.processShared();
        this.processIncludes();
        try {
            this.featureSet.serialize(file);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.project.getArtifact().setFile(file);
    }

    private void processIncludes() throws MojoExecutionException {
        if (this.includes == null) {
            return;
        }
        for (Dependency include : this.includes) {
            File featureSetFile = this.resolve(include);
            FeatureSet includedFeatureSet = null;
            try {
                includedFeatureSet = FeatureSet.deserialize(featureSetFile);
            }
            catch (ParserConfigurationException e) {
                throw new MojoExecutionException("Unable to process includes", (Exception)e);
            }
            catch (SAXException e) {
                throw new MojoExecutionException("Unable to process includes", (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to process includes", (Exception)e);
            }
            for (org.apache.maven.model.Dependency extension : includedFeatureSet.getExtensions()) {
                this.resolve(extension);
                this.featureSet.addExtension(extension);
            }
            for (org.apache.maven.model.Dependency sharedLibrary : includedFeatureSet.getSharedLibraries()) {
                this.resolve(sharedLibrary);
                this.featureSet.addSharedLibrary(sharedLibrary);
            }
        }
    }

    private void processExtensions() throws MojoExecutionException {
        if (this.extensions == null) {
            return;
        }
        for (Dependency extension : this.extensions) {
            this.resolve(extension);
            this.featureSet.addExtension(extension);
        }
    }

    private void processShared() throws MojoExecutionException {
        if (this.shared == null) {
            return;
        }
        for (Dependency sharedLibrary : this.shared) {
            this.resolve(sharedLibrary);
            this.featureSet.addSharedLibrary(sharedLibrary);
        }
    }

    private File resolve(org.apache.maven.model.Dependency dep) throws MojoExecutionException {
        if (dep.getVersion() == null) {
            this.resolveDependencyVersion(dep);
        }
        Artifact artifact = this.createArtifact(dep);
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            return artifact.getFile();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Artifact createArtifact(org.apache.maven.model.Dependency dep) {
        return this.artifactFactory.createArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), "runtime", dep.getType());
    }

    private void resolveDependencyVersion(org.apache.maven.model.Dependency dep) {
        List dependencies = this.project.getDependencyManagement().getDependencies();
        for (org.apache.maven.model.Dependency dependecy : dependencies) {
            if (!dependecy.getGroupId().equals(dep.getGroupId()) || !dependecy.getArtifactId().equals(dep.getArtifactId())) continue;
            dep.setVersion(dependecy.getVersion());
        }
    }
}

