/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.featureset;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.model.Dependency;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureSet {
    private Set<Dependency> extensions = new HashSet<Dependency>();
    private Set<Dependency> sharedLibraries = new HashSet<Dependency>();

    public void addExtension(Dependency extension) {
        this.extensions.add(extension);
    }

    public void addSharedLibrary(Dependency sharedLibrary) {
        this.sharedLibraries.add(sharedLibrary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(File artifactFile) throws FileNotFoundException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileOutputStream(artifactFile));
            writer.println("<featureSet>");
            for (Dependency extension : this.extensions) {
                writer.println("    <extension>");
                writer.println("        <artifactId>" + extension.getArtifactId() + "</artifactId>");
                writer.println("        <groupId>" + extension.getGroupId() + "</groupId>");
                writer.println("        <version>" + extension.getVersion() + "</version>");
                writer.println("    </extension>");
            }
            for (Dependency sharedLibrary : this.sharedLibraries) {
                writer.println("    <shared>");
                writer.println("        <artifactId>" + sharedLibrary.getArtifactId() + "</artifactId>");
                writer.println("        <groupId>" + sharedLibrary.getGroupId() + "</groupId>");
                writer.println("        <version>" + sharedLibrary.getVersion() + "</version>");
                writer.println("    </shared>");
            }
            writer.println("</featureSet>");
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static FeatureSet deserialize(File featureSetFile) throws ParserConfigurationException, SAXException, IOException {
        FeatureSet featureSet = new FeatureSet();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document featureSetDoc = db.parse(featureSetFile);
        NodeList extensionList = featureSetDoc.getElementsByTagName("extension");
        for (int i = 0; i < extensionList.getLength(); ++i) {
            Dependency extension = FeatureSet.createDependency(extensionList, i);
            featureSet.addExtension(extension);
        }
        NodeList sharedList = featureSetDoc.getElementsByTagName("shared");
        for (int i = 0; i < sharedList.getLength(); ++i) {
            Dependency sharedLibrary = FeatureSet.createDependency(sharedList, i);
            featureSet.addSharedLibrary(sharedLibrary);
        }
        return featureSet;
    }

    private static Dependency createDependency(NodeList extensionList, int i) {
        Element extensionElement = (Element)extensionList.item(i);
        Element artifactIdElement = (Element)extensionElement.getElementsByTagName("artifactId").item(0);
        Element groupIdElement = (Element)extensionElement.getElementsByTagName("groupId").item(0);
        Element versionElement = (Element)extensionElement.getElementsByTagName("version").item(0);
        Dependency extension = new Dependency();
        extension.setArtifactId(artifactIdElement.getTextContent());
        extension.setGroupId(groupIdElement.getTextContent());
        extension.setVersion(versionElement.getTextContent());
        return extension;
    }

    public Set<Dependency> getSharedLibraries() {
        return this.sharedLibraries;
    }

    public Set<Dependency> getExtensions() {
        return this.extensions;
    }
}

