/*
 * See the NOTICE file distributed with this work for information
 * regarding copyright ownership.  This file is licensed
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.fabric3.introspection.java;

import org.fabric3.introspection.IntrospectionException;

/**
 * @version $Rev: 4278 $ $Date: 2008-05-20 00:22:30 -0700 (Tue, 20 May 2008) $
 */
public class ImplementationNotFoundException extends IntrospectionException {
    private static final long serialVersionUID = -5872848682083357587L;

    public ImplementationNotFoundException(String identifier) {
        super(identifier);
    }

    public ImplementationNotFoundException(String identifier, Throwable cause) {
        super(identifier, cause);
    }

    public String getMessage() {
        return "Unable to load implementation class: " + getIdentifier();
    }
}
