/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.generator;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.implementation.java.generator.CallbackSiteNotFound;
import org.fabric3.implementation.java.generator.JavaGenerationHelper;
import org.fabric3.implementation.java.model.JavaImplementation;
import org.fabric3.implementation.java.provision.JavaComponentDefinition;
import org.fabric3.implementation.java.provision.JavaSourceDefinition;
import org.fabric3.implementation.java.provision.JavaTargetDefinition;
import org.fabric3.implementation.pojo.generator.GenerationHelper;
import org.fabric3.implementation.pojo.provision.InstanceFactoryDefinition;
import org.fabric3.implementation.pojo.provision.PojoComponentDefinition;
import org.fabric3.model.type.component.AbstractComponentType;
import org.fabric3.model.type.component.CallbackDefinition;
import org.fabric3.model.type.component.ComponentDefinition;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.component.Scope;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.physical.InteractionType;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.model.type.java.InjectableType;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.policy.EffectivePolicy;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaGenerationHelperImpl
implements JavaGenerationHelper {
    private static final QName PROPAGATES_CONVERSATION_POLICY = new QName("urn:fabric3.org:policy", "propagatesConversationPolicy");
    private final GenerationHelper helper;
    private ContractMatcher matcher;

    public JavaGenerationHelperImpl(@Reference GenerationHelper helper, @Reference ContractMatcher matcher) {
        this.helper = helper;
        this.matcher = matcher;
    }

    @Override
    public void generate(JavaComponentDefinition definition, LogicalComponent<? extends JavaImplementation> component) throws GenerationException {
        ComponentDefinition logical = component.getDefinition();
        JavaImplementation implementation = (JavaImplementation)logical.getImplementation();
        InjectingComponentType type = (InjectingComponentType)implementation.getComponentType();
        String scope = type.getScope();
        InstanceFactoryDefinition factoryDefinition = new InstanceFactoryDefinition();
        factoryDefinition.setReinjectable(Scope.COMPOSITE.getScope().equals(scope));
        factoryDefinition.setConstructor(type.getConstructor());
        factoryDefinition.setInitMethod(type.getInitMethod());
        factoryDefinition.setDestroyMethod(type.getDestroyMethod());
        factoryDefinition.setImplementationClass(implementation.getImplementationClass());
        this.helper.processInjectionSites(type, factoryDefinition);
        definition.setScope(scope);
        definition.setEagerInit(type.isEagerInit());
        definition.setMaxAge(type.getMaxAge());
        definition.setMaxIdleTime(type.getMaxIdleTime());
        definition.setProviderDefinition(factoryDefinition);
        this.helper.processPropertyValues(component, (PojoComponentDefinition)definition);
    }

    @Override
    public void generateWireSource(JavaSourceDefinition definition, LogicalReference reference, EffectivePolicy policy) throws GenerationException {
        URI uri = reference.getUri();
        ServiceContract serviceContract = reference.getDefinition().getServiceContract();
        String interfaceName = serviceContract.getQualifiedInterfaceName();
        definition.setUri(uri);
        definition.setInjectable(new Injectable(InjectableType.REFERENCE, uri.getFragment()));
        definition.setInterfaceName(interfaceName);
        definition.setOptimizable(true);
        boolean conversational = serviceContract.isConversational();
        this.calculateConversationalPolicy(definition, policy, conversational);
        if (reference.getDefinition().isKeyed()) {
            definition.setKeyed(true);
            DataType type = reference.getDefinition().getKeyDataType();
            String className = type.getPhysical().getName();
            definition.setKeyClassName(className);
        }
    }

    @Override
    public void generateCallbackWireSource(JavaSourceDefinition definition, LogicalComponent<? extends JavaImplementation> component, ServiceContract serviceContract, EffectivePolicy policy) throws GenerationException {
        String interfaceName = serviceContract.getQualifiedInterfaceName();
        InjectingComponentType type = (InjectingComponentType)((JavaImplementation)component.getDefinition().getImplementation()).getComponentType();
        String name = null;
        for (CallbackDefinition entry : type.getCallbacks().values()) {
            ServiceContract candidate = entry.getServiceContract();
            if (!this.matcher.isAssignableFrom(candidate, serviceContract)) continue;
            name = entry.getName();
            break;
        }
        if (name == null) {
            String interfaze = serviceContract.getQualifiedInterfaceName();
            throw new CallbackSiteNotFound("Callback injection site not found for type: " + interfaze, interfaze);
        }
        Injectable injectable = new Injectable(InjectableType.CALLBACK, name);
        definition.setInjectable(injectable);
        definition.setInterfaceName(interfaceName);
        URI uri = URI.create(component.getUri().toString() + "#" + name);
        definition.setUri(uri);
        definition.setOptimizable(false);
    }

    @Override
    public void generateResourceWireSource(JavaSourceDefinition wireDefinition, LogicalResource<?> resource) throws GenerationException {
        URI uri = resource.getUri();
        ServiceContract serviceContract = resource.getResourceDefinition().getServiceContract();
        String interfaceName = serviceContract.getQualifiedInterfaceName();
        wireDefinition.setUri(uri);
        wireDefinition.setInjectable(new Injectable(InjectableType.RESOURCE, uri.getFragment()));
        wireDefinition.setInterfaceName(interfaceName);
    }

    @Override
    public void generateWireTarget(JavaTargetDefinition definition, LogicalService service) throws GenerationException {
        LogicalComponent component = (LogicalComponent)service.getParent();
        URI uri = service.getUri();
        definition.setUri(uri);
        ComponentDefinition componentDefinition = component.getDefinition();
        Implementation implementation = componentDefinition.getImplementation();
        AbstractComponentType componentType = implementation.getComponentType();
        String scope = componentType.getScope();
        definition.setOptimizable("COMPOSITE".equals(scope));
    }

    private void calculateConversationalPolicy(JavaSourceDefinition definition, EffectivePolicy policy, boolean conversational) {
        for (PolicySet policySet : policy.getEndpointPolicySets()) {
            if (!PROPAGATES_CONVERSATION_POLICY.equals(policySet.getName())) continue;
            definition.setInteractionType(InteractionType.PROPAGATES_CONVERSATION);
            return;
        }
        if (conversational) {
            definition.setInteractionType(InteractionType.CONVERSATIONAL);
        }
    }
}

