/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.introspection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.implementation.java.introspection.IllegalManagementInterface;
import org.fabric3.implementation.java.model.JavaImplementation;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.component.Property;
import org.fabric3.model.type.component.ReferenceDefinition;
import org.fabric3.model.type.component.Scope;
import org.fabric3.model.type.component.ServiceDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.MultiplicityType;
import org.fabric3.spi.introspection.java.NoConstructorFound;
import org.fabric3.spi.introspection.java.UnknownInjectionType;
import org.fabric3.spi.introspection.java.annotation.AmbiguousConstructor;
import org.fabric3.spi.introspection.java.annotation.PolicyAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.binding.JMXBinding;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.InjectableType;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.fabric3.spi.model.type.java.Signature;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaHeuristic
implements HeuristicProcessor<JavaImplementation> {
    private final IntrospectionHelper helper;
    private final JavaContractProcessor contractProcessor;
    private final HeuristicProcessor<JavaImplementation> serviceHeuristic;
    private PolicyAnnotationProcessor policyProcessor;

    public JavaHeuristic(@Reference IntrospectionHelper helper, @Reference JavaContractProcessor contractProcessor, @Reference(name="service") HeuristicProcessor<JavaImplementation> serviceHeuristic) {
        this.helper = helper;
        this.contractProcessor = contractProcessor;
        this.serviceHeuristic = serviceHeuristic;
    }

    @Reference
    public void setPolicyProcessor(PolicyAnnotationProcessor processor) {
        this.policyProcessor = processor;
    }

    public void applyHeuristics(JavaImplementation implementation, Class<?> implClass, IntrospectionContext context) {
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        this.serviceHeuristic.applyHeuristics((Implementation)implementation, implClass, context);
        if (componentType.getConstructor() == null) {
            Signature ctor = this.findConstructor(implClass, context);
            componentType.setConstructor(ctor);
        }
        if (componentType.getProperties().isEmpty() && componentType.getReferences().isEmpty() && componentType.getResources().isEmpty()) {
            this.evaluateConstructor(implementation, implClass, context);
            this.evaluateSetters(implementation, implClass, context);
            this.evaluateFields(implementation, implClass, context);
        }
        for (ServiceDefinition service : componentType.getServices().values()) {
            if (!service.isManagement()) continue;
            String scope = componentType.getScope();
            if (!Scope.COMPOSITE.getScope().equals(scope)) {
                ServiceContract contract = service.getServiceContract();
                IllegalManagementInterface warning = new IllegalManagementInterface(contract.getInterfaceName(), implClass.getName());
                context.addWarning((ValidationFailure)warning);
                continue;
            }
            JMXBinding binding = new JMXBinding();
            service.addBinding((BindingDefinition)binding);
        }
    }

    private Signature findConstructor(Class<?> implClass, IntrospectionContext context) {
        Constructor<?>[] constructors = implClass.getDeclaredConstructors();
        Constructor<?> selected = null;
        if (constructors.length == 1) {
            selected = constructors[0];
        } else {
            for (Constructor<?> constructor : constructors) {
                if (!constructor.isAnnotationPresent(org.osoa.sca.annotations.Constructor.class)) continue;
                if (selected != null) {
                    context.addError((ValidationFailure)new AmbiguousConstructor(implClass));
                    return null;
                }
                selected = constructor;
            }
            if (selected == null) {
                context.addError((ValidationFailure)new NoConstructorFound(implClass));
                return null;
            }
        }
        return new Signature(selected);
    }

    private void evaluateConstructor(JavaImplementation implementation, Class<?> implClass, IntrospectionContext context) {
        Constructor constructor;
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        Map sites = componentType.getInjectionSites();
        try {
            Signature ctor = componentType.getConstructor();
            if (ctor == null) {
                return;
            }
            constructor = ctor.getConstructor(implClass);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        Type[] parameterTypes = constructor.getGenericParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, i);
            if (sites.containsKey(site)) continue;
            TypeMapping typeMapping = context.getTypeMapping(implClass);
            Class parameterType = this.helper.getBaseType(parameterTypes[i], typeMapping);
            String name = this.helper.getSiteName(constructor, i, null);
            Annotation[] annotations = constructor.getParameterAnnotations()[i];
            this.processSite(componentType, name, parameterType, implClass, (InjectionSite)site, annotations, context);
        }
    }

    private void evaluateSetters(JavaImplementation implementation, Class<?> implClass, IntrospectionContext context) {
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        Map sites = componentType.getInjectionSites();
        Set setters = this.helper.getInjectionMethods(implClass, componentType.getServices().values());
        for (Method setter : setters) {
            MethodInjectionSite site = new MethodInjectionSite(setter, 0);
            if (sites.containsKey(site)) continue;
            String name = this.helper.getSiteName(setter, null);
            TypeMapping typeMapping = context.getTypeMapping(implClass);
            Type genericType = setter.getGenericParameterTypes()[0];
            Class parameterType = this.helper.getBaseType(genericType, typeMapping);
            Annotation[] annotations = setter.getAnnotations();
            this.processSite(componentType, name, parameterType, implClass, (InjectionSite)site, annotations, context);
        }
    }

    private void evaluateFields(JavaImplementation implementation, Class<?> implClass, IntrospectionContext context) {
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        Map sites = componentType.getInjectionSites();
        Set fields = this.helper.getInjectionFields(implClass);
        for (Field field : fields) {
            FieldInjectionSite site = new FieldInjectionSite(field);
            if (sites.containsKey(site)) continue;
            String name = this.helper.getSiteName(field, null);
            TypeMapping typeMapping = context.getTypeMapping(implClass);
            Class parameterType = this.helper.getBaseType(field.getGenericType(), typeMapping);
            Annotation[] annotations = field.getAnnotations();
            this.processSite(componentType, name, parameterType, implClass, (InjectionSite)site, annotations, context);
        }
    }

    private void processSite(InjectingComponentType componentType, String name, Class<?> parameterType, Class<?> declaringClass, InjectionSite site, Annotation[] annotations, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(declaringClass);
        InjectableType type = this.helper.inferType(parameterType, typeMapping);
        switch (type) {
            case PROPERTY: {
                this.addProperty(componentType, name, parameterType, declaringClass, site, context);
                break;
            }
            case REFERENCE: {
                this.addReference(componentType, name, parameterType, declaringClass, site, annotations, context);
                break;
            }
            case CALLBACK: {
                context.addError((ValidationFailure)new UnknownInjectionType(site, type, componentType.getImplClass()));
                break;
            }
            default: {
                context.addError((ValidationFailure)new UnknownInjectionType(site, type, componentType.getImplClass()));
            }
        }
    }

    private void addProperty(InjectingComponentType componentType, String name, Type type, Class<?> declaringClass, InjectionSite site, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(declaringClass);
        Property property = new Property(name);
        MultiplicityType multiplicityType = this.helper.introspectMultiplicity(type, typeMapping);
        property.setMany(MultiplicityType.COLLECTION == multiplicityType || MultiplicityType.DICTIONARY == multiplicityType);
        componentType.add(property, site);
    }

    private void addReference(InjectingComponentType componentType, String name, Class<?> parameterType, Class<?> declaringClass, InjectionSite site, Annotation[] annotations, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(declaringClass);
        JavaServiceContract contract = this.contractProcessor.introspect(parameterType, context);
        ReferenceDefinition reference = new ReferenceDefinition(name, (ServiceContract)contract);
        this.helper.processMultiplicity(reference, false, parameterType, typeMapping);
        if (this.policyProcessor != null) {
            for (Annotation annotation : annotations) {
                this.policyProcessor.process(annotation, (PolicyAware)reference, context);
            }
        }
        componentType.add(reference, site);
    }
}

