/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.introspection;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import org.fabric3.api.annotation.Management;
import org.fabric3.implementation.java.model.JavaImplementation;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.ServiceDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.annotation.PolicyAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.introspection.java.policy.OperationPolicyIntrospector;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaServiceHeuristic
implements HeuristicProcessor<JavaImplementation> {
    private final IntrospectionHelper helper;
    private final JavaContractProcessor contractProcessor;
    private PolicyAnnotationProcessor policyProcessor;
    private OperationPolicyIntrospector policyIntrospector;

    public JavaServiceHeuristic(@Reference IntrospectionHelper helper, @Reference JavaContractProcessor contractProcessor, @Reference OperationPolicyIntrospector policyIntrospector) {
        this.helper = helper;
        this.contractProcessor = contractProcessor;
        this.policyIntrospector = policyIntrospector;
    }

    @Reference
    public void setPolicyProcessor(PolicyAnnotationProcessor processor) {
        this.policyProcessor = processor;
    }

    public void applyHeuristics(JavaImplementation implementation, Class<?> implClass, IntrospectionContext context) {
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        if (!componentType.getServices().isEmpty()) {
            return;
        }
        Set interfaces = this.helper.getImplementedInterfaces(implClass);
        if (interfaces.size() == 1) {
            Class service = (Class)interfaces.iterator().next();
            ServiceDefinition serviceDefinition = this.createServiceDefinition(service, implClass, context);
            componentType.add(serviceDefinition);
        } else if (interfaces.size() == 2) {
            Iterator iter = interfaces.iterator();
            Class serviceOne = (Class)iter.next();
            Class serviceTwo = (Class)iter.next();
            if (serviceOne.isAnnotationPresent(Management.class)) {
                ServiceDefinition serviceOneDefinition = this.createManagementServiceDefinition(serviceOne, implClass, context);
                componentType.add(serviceOneDefinition);
                ServiceDefinition serviceTwoDefinition = this.createServiceDefinition(serviceTwo, implClass, context);
                componentType.add(serviceTwoDefinition);
            } else if (serviceTwo.isAnnotationPresent(Management.class)) {
                ServiceDefinition serviceOneDefinition = this.createServiceDefinition(serviceOne, implClass, context);
                componentType.add(serviceOneDefinition);
                ServiceDefinition serviceTwoDefinition = this.createManagementServiceDefinition(serviceTwo, implClass, context);
                componentType.add(serviceTwoDefinition);
            } else {
                ServiceDefinition serviceDefinition = this.createServiceDefinition(implClass, implClass, context);
                componentType.add(serviceDefinition);
            }
        } else {
            ServiceDefinition serviceDefinition = this.createServiceDefinition(implClass, implClass, context);
            componentType.add(serviceDefinition);
        }
    }

    private ServiceDefinition createServiceDefinition(Class<?> serviceInterface, Class<?> implClass, IntrospectionContext context) {
        JavaServiceContract contract = this.contractProcessor.introspect(serviceInterface, context);
        ServiceDefinition definition = new ServiceDefinition(contract.getInterfaceName(), (ServiceContract)contract);
        Annotation[] annotations = serviceInterface.getAnnotations();
        if (this.policyProcessor != null) {
            for (Annotation annotation : annotations) {
                this.policyProcessor.process(annotation, (PolicyAware)definition, context);
            }
            this.policyIntrospector.introspectPolicyOnOperations((ServiceContract)contract, implClass, context);
        }
        return definition;
    }

    private ServiceDefinition createManagementServiceDefinition(Class<?> serviceInterface, Class<?> implClass, IntrospectionContext context) {
        JavaServiceContract contract = this.contractProcessor.introspect(serviceInterface, implClass, context);
        ServiceDefinition service = new ServiceDefinition(contract.getInterfaceName(), (ServiceContract)contract);
        service.setManagement(true);
        return service;
    }
}

