/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.implementation.java.provision.JavaComponentDefinition;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.pojo.builder.PojoComponentBuilder;
import org.fabric3.implementation.pojo.instancefactory.InstanceFactoryBuilder;
import org.fabric3.implementation.pojo.instancefactory.InstanceFactoryProvider;
import org.fabric3.implementation.pojo.provision.InstanceFactoryDefinition;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.component.ScopeRegistry;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.transform.TransformerRegistry;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JavaComponentBuilder<T>
extends PojoComponentBuilder<T, JavaComponentDefinition, JavaComponent<T>> {
    private ScopeRegistry scopeRegistry;
    private InstanceFactoryBuilder<T> factoryBuilder;

    public JavaComponentBuilder(@Reference ScopeRegistry scopeRegistry, @Reference InstanceFactoryBuilder<T> factoryBuilder, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference TransformerRegistry transformerRegistry, @Reference IntrospectionHelper helper) {
        super(classLoaderRegistry, transformerRegistry, helper);
        this.scopeRegistry = scopeRegistry;
        this.factoryBuilder = factoryBuilder;
    }

    public JavaComponent<T> build(JavaComponentDefinition definition) throws BuilderException {
        URI uri = definition.getComponentUri();
        QName deployable = definition.getDeployable();
        ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(definition.getClassLoaderId());
        String scopeName = definition.getScope();
        Scope scope = this.scopeRegistry.getScope(scopeName);
        ScopeContainer scopeContainer = this.scopeRegistry.getScopeContainer(scope);
        InstanceFactoryDefinition factoryDefinition = definition.getFactoryDefinition();
        InstanceFactoryProvider provider = this.factoryBuilder.build(factoryDefinition, classLoader);
        this.createPropertyFactories(definition, provider);
        long idleTime = definition.getMaxIdleTime();
        long age = definition.getMaxAge();
        boolean eager = definition.isEagerInit();
        JavaComponent component = new JavaComponent(uri, provider, scopeContainer, deployable, eager, idleTime, age);
        this.buildContexts(component, provider);
        return component;
    }
}

