/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import org.fabric3.implementation.java.provision.JavaTargetDefinition;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.pojo.component.InvokerInterceptor;
import org.fabric3.implementation.pojo.provision.PojoSourceDefinition;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.builder.component.WireAttachException;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.util.UriHelper;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTargetWireAttacher
implements TargetWireAttacher<JavaTargetDefinition> {
    private final ComponentManager manager;
    private final ClassLoaderRegistry classLoaderRegistry;

    public JavaTargetWireAttacher(@Reference ComponentManager manager, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.manager = manager;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(PhysicalSourceDefinition sourceDefinition, JavaTargetDefinition targetDefinition, Wire wire) throws WireAttachException {
        URI targetName = UriHelper.getDefragmentedName((URI)targetDefinition.getUri());
        Component component = this.manager.getComponent(targetName);
        assert (component instanceof JavaComponent);
        JavaComponent target = (JavaComponent)component;
        ScopeContainer scopeContainer = target.getScopeContainer();
        Class implementationClass = target.getImplementationClass();
        ClassLoader loader = implementationClass.getClassLoader();
        for (InvocationChain chain : wire.getInvocationChains()) {
            Method method;
            PhysicalOperationDefinition operation = chain.getPhysicalOperation();
            List params = operation.getTargetParameterTypes();
            Class[] paramTypes = new Class[params.size()];
            assert (loader != null);
            for (int i = 0; i < params.size(); ++i) {
                String param = (String)params.get(i);
                try {
                    paramTypes[i] = this.classLoaderRegistry.loadClass(loader, param);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    URI sourceUri = sourceDefinition.getUri();
                    URI targetUri = targetDefinition.getUri();
                    throw new WireAttachException("Implementation class not found when wiring " + sourceUri + " to " + targetUri, (Throwable)e);
                }
            }
            try {
                method = implementationClass.getMethod(operation.getName(), paramTypes);
            }
            catch (NoSuchMethodException e) {
                URI sourceUri = sourceDefinition.getUri();
                URI targetUri = targetDefinition.getUri();
                throw new WireAttachException("No matching method found when wiring " + sourceUri + " to " + targetUri, (Throwable)e);
            }
            boolean endsConversation = operation.isEndsConversation();
            boolean callback = targetDefinition.isCallback();
            if (callback) {
                endsConversation = false;
            }
            InvokerInterceptor interceptor = sourceDefinition instanceof PojoSourceDefinition && targetDefinition.getClassLoaderId().equals(sourceDefinition.getClassLoaderId()) ? this.createInterceptor(method, callback, endsConversation, (AtomicComponent)target, scopeContainer) : this.createInterceptor(method, callback, endsConversation, (AtomicComponent)target, scopeContainer, loader);
            chain.addInterceptor(interceptor);
        }
    }

    public void detach(PhysicalSourceDefinition source, JavaTargetDefinition target) throws WiringException {
    }

    public ObjectFactory<?> createObjectFactory(JavaTargetDefinition target) throws WiringException {
        URI targetId = UriHelper.getDefragmentedName((URI)target.getUri());
        JavaComponent targetComponent = (JavaComponent)this.manager.getComponent(targetId);
        return targetComponent.createObjectFactory();
    }

    private <T> InvokerInterceptor<T> createInterceptor(Method method, boolean callback, boolean endsConvesation, AtomicComponent<T> component, ScopeContainer scopeContainer, ClassLoader loader) {
        return new InvokerInterceptor(method, callback, endsConvesation, component, scopeContainer, loader);
    }

    private <T> InvokerInterceptor<T> createInterceptor(Method method, boolean callback, boolean endsConvesation, AtomicComponent<T> component, ScopeContainer scopeContainer) {
        return new InvokerInterceptor(method, callback, endsConvesation, component, scopeContainer);
    }
}

