/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.proxy.jdk;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.UUID;
import org.fabric3.pojo.component.ConversationImpl;
import org.fabric3.proxy.jdk.NoMethodForOperationException;
import org.fabric3.spi.component.ConversationExpirationCallback;
import org.fabric3.spi.component.InstanceInvocationException;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.invocation.CallFrame;
import org.fabric3.spi.invocation.ConversationContext;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.MessageImpl;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.invocation.WorkContextTunnel;
import org.fabric3.spi.model.physical.InteractionType;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.osoa.sca.Conversation;
import org.osoa.sca.ServiceReference;
import org.osoa.sca.ServiceUnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDKInvocationHandler<B>
implements ConversationExpirationCallback,
InvocationHandler,
ServiceReference<B> {
    private final Class<B> businessInterface;
    private final B proxy;
    private final InteractionType type;
    private final Map<Method, InvocationChain> chains;
    private final ScopeContainer<Conversation> scopeContainer;
    private Conversation conversation;
    private Object userConversationId;
    private String callbackUri;

    public JDKInvocationHandler(Class<B> interfaze, String callbackUri, Map<Method, InvocationChain> mapping) throws NoMethodForOperationException {
        this(interfaze, InteractionType.STATELESS, callbackUri, mapping, null);
    }

    public JDKInvocationHandler(Class<B> interfaze, InteractionType type, String callbackUri, Map<Method, InvocationChain> mapping, ScopeContainer<Conversation> scopeContainer) throws NoMethodForOperationException {
        this.callbackUri = callbackUri;
        assert (mapping != null);
        this.businessInterface = interfaze;
        ClassLoader loader = interfaze.getClassLoader();
        this.proxy = interfaze.cast(Proxy.newProxyInstance(loader, new Class[]{interfaze}, (InvocationHandler)this));
        this.chains = mapping;
        this.scopeContainer = scopeContainer;
        this.type = type;
    }

    public void expire(Conversation conversation) {
        this.conversation = null;
    }

    public B getService() {
        return this.proxy;
    }

    public ServiceReference<B> getServiceReference() {
        return this;
    }

    public boolean isConversational() {
        return this.type != InteractionType.STATELESS;
    }

    public Class<B> getBusinessInterface() {
        return this.businessInterface;
    }

    public Conversation getConversation() {
        return this.conversation;
    }

    public Object getConversationID() {
        return this.userConversationId;
    }

    public void setConversationID(Object conversationId) throws IllegalStateException {
        if (this.conversation != null) {
            throw new IllegalStateException("A conversation is already active");
        }
        this.userConversationId = conversationId;
    }

    public Object getCallbackID() {
        throw new UnsupportedOperationException();
    }

    public void setCallbackID(Object callbackID) {
        throw new UnsupportedOperationException();
    }

    public Object getCallback() {
        throw new UnsupportedOperationException();
    }

    public void setCallback(Object callback) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        InvocationChain chain = this.chains.get(method);
        if (chain == null) {
            return this.handleProxyMethod(method);
        }
        Interceptor headInterceptor = chain.getHeadInterceptor();
        assert (headInterceptor != null);
        WorkContext workContext = WorkContextTunnel.getThreadWorkContext();
        CallFrame frame = this.initalizeCallFrame(workContext);
        MessageImpl msg = new MessageImpl();
        msg.setBody((Object)args);
        msg.setWorkContext(workContext);
        try {
            Message resp;
            try {
                resp = headInterceptor.invoke((Message)msg);
            }
            catch (ServiceUnavailableException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ServiceUnavailableException((Throwable)e);
            }
            Object body = resp.getBody();
            if (resp.isFault()) {
                throw (Throwable)body;
            }
            Object object = body;
            return object;
        }
        finally {
            PhysicalOperationDefinition operation;
            if ((InteractionType.CONVERSATIONAL == this.type || InteractionType.PROPAGATES_CONVERSATION == this.type) && (operation = chain.getPhysicalOperation()).isEndsConversation()) {
                this.conversation = null;
            }
            if (frame != null) {
                workContext.popCallFrame();
            }
        }
    }

    private CallFrame initalizeCallFrame(WorkContext workContext) {
        CallFrame frame = null;
        if (InteractionType.CONVERSATIONAL == this.type && this.conversation == null) {
            this.conversation = new ConversationImpl(this.createConversationID(), this.scopeContainer);
            this.scopeContainer.registerCallback(this.conversation, (ConversationExpirationCallback)this);
            frame = new CallFrame(this.callbackUri, null, this.conversation, ConversationContext.NEW);
            workContext.addCallFrame(frame);
        } else if (InteractionType.PROPAGATES_CONVERSATION == this.type && this.conversation == null) {
            Conversation propagated = workContext.peekCallFrame().getConversation();
            frame = new CallFrame(this.callbackUri, null, propagated, ConversationContext.PROPAGATE);
            workContext.addCallFrame(frame);
        } else if (InteractionType.CONVERSATIONAL == this.type) {
            frame = new CallFrame(this.callbackUri, null, this.conversation, null);
            workContext.addCallFrame(frame);
        } else if (this.callbackUri != null) {
            frame = new CallFrame(this.callbackUri, null, null, null);
            workContext.addCallFrame(frame);
        }
        return frame;
    }

    private Object createConversationID() {
        if (this.userConversationId != null) {
            return this.userConversationId;
        }
        return UUID.randomUUID().toString();
    }

    private Object handleProxyMethod(Method method) throws InstanceInvocationException {
        if (method.getParameterTypes().length == 0 && "toString".equals(method.getName())) {
            return "[Proxy - " + Integer.toHexString(this.hashCode()) + "]";
        }
        if (method.getDeclaringClass().equals(Object.class) && "equals".equals(method.getName())) {
            throw new UnsupportedOperationException();
        }
        if (Object.class.equals(method.getDeclaringClass()) && "hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        String op = method.getName();
        throw new InstanceInvocationException("Operation not configured: " + op, op);
    }
}

