/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.proxy.jdk;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.model.type.component.Scope;
import org.fabric3.pojo.builder.ProxyCreationException;
import org.fabric3.pojo.builder.ProxyService;
import org.fabric3.proxy.jdk.CallbackWireObjectFactory;
import org.fabric3.proxy.jdk.JDKInvocationHandler;
import org.fabric3.proxy.jdk.MultiThreadedCallbackInvocationHandler;
import org.fabric3.proxy.jdk.NoMethodForOperationException;
import org.fabric3.proxy.jdk.StatefulCallbackInvocationHandler;
import org.fabric3.proxy.jdk.WireObjectFactory;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.component.ScopeRegistry;
import org.fabric3.spi.model.physical.InteractionType;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.CallableReference;
import org.osoa.sca.Conversation;
import org.osoa.sca.annotations.Constructor;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKProxyService
implements ProxyService {
    private ClassLoaderRegistry classLoaderRegistry;
    private ScopeRegistry scopeRegistry;
    private ScopeContainer<Conversation> conversationalContainer;

    public JDKProxyService() {
    }

    @Constructor
    public JDKProxyService(@Reference ClassLoaderRegistry classLoaderRegistry, @Reference ScopeRegistry scopeRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
        this.scopeRegistry = scopeRegistry;
    }

    public <T> ObjectFactory<T> createObjectFactory(Class<T> interfaze, InteractionType type, Wire wire, String callbackUri) throws ProxyCreationException {
        Map<Method, InvocationChain> mappings = this.createInterfaceToWireMapping(interfaze, wire);
        return new WireObjectFactory<T>(interfaze, type, callbackUri, this, mappings);
    }

    public <T> ObjectFactory<T> createCallbackObjectFactory(Class<T> interfaze, ScopeContainer container, URI callbackUri, Wire wire) throws ProxyCreationException {
        Map<Method, InvocationChain> operationMappings = this.createInterfaceToWireMapping(interfaze, wire);
        HashMap<String, Map<Method, InvocationChain>> mappings = new HashMap<String, Map<Method, InvocationChain>>();
        mappings.put(callbackUri.toString(), operationMappings);
        return new CallbackWireObjectFactory<T>(interfaze, container, this, mappings);
    }

    public ObjectFactory<?> updateCallbackObjectFactory(ObjectFactory<?> factory, URI callbackUri, Wire wire) throws ProxyCreationException {
        if (!(factory instanceof CallbackWireObjectFactory)) {
            String name = factory.getClass().getName();
            throw new IllegalArgumentException("ObjectFactory must be an instance of " + CallbackWireObjectFactory.class.getName() + ": " + name);
        }
        CallbackWireObjectFactory callbackFactory = (CallbackWireObjectFactory)factory;
        Class interfaze = callbackFactory.getInterfaze();
        Map<Method, InvocationChain> operationMappings = this.createInterfaceToWireMapping(interfaze, wire);
        callbackFactory.updateMappings(callbackUri.toString(), operationMappings);
        return callbackFactory;
    }

    public <T> T createProxy(Class<T> interfaze, InteractionType type, String callbackUri, Map<Method, InvocationChain> mappings) throws ProxyCreationException {
        JDKInvocationHandler<T> handler;
        if (InteractionType.CONVERSATIONAL == type || InteractionType.PROPAGATES_CONVERSATION == type) {
            ScopeContainer<Conversation> scopeContainer = this.getContainer();
            handler = new JDKInvocationHandler<T>(interfaze, type, callbackUri, mappings, scopeContainer);
        } else {
            handler = new JDKInvocationHandler<T>(interfaze, callbackUri, mappings);
        }
        return handler.getService();
    }

    public <T> T createCallbackProxy(Class<T> interfaze, Map<String, Map<Method, InvocationChain>> mappings) throws ProxyCreationException {
        ClassLoader cl = interfaze.getClassLoader();
        MultiThreadedCallbackInvocationHandler<T> handler = new MultiThreadedCallbackInvocationHandler<T>(interfaze, mappings);
        return interfaze.cast(Proxy.newProxyInstance(cl, new Class[]{interfaze}, handler));
    }

    public <T> T createStatefullCallbackProxy(Class<T> interfaze, Map<Method, InvocationChain> mapping, ScopeContainer<?> container) {
        ClassLoader cl = interfaze.getClassLoader();
        StatefulCallbackInvocationHandler<T> handler = new StatefulCallbackInvocationHandler<T>(interfaze, container, mapping);
        return interfaze.cast(Proxy.newProxyInstance(cl, new Class[]{interfaze}, handler));
    }

    public <B, R extends CallableReference<B>> R cast(B target) throws IllegalArgumentException {
        InvocationHandler handler = Proxy.getInvocationHandler(target);
        if (handler instanceof JDKInvocationHandler) {
            JDKInvocationHandler jdkHandler = (JDKInvocationHandler)handler;
            return (R)jdkHandler.getServiceReference();
        }
        if (handler instanceof MultiThreadedCallbackInvocationHandler) {
            throw new UnsupportedOperationException();
        }
        throw new IllegalArgumentException("Not a Fabric3 SCA proxy");
    }

    private Map<Method, InvocationChain> createInterfaceToWireMapping(Class<?> interfaze, Wire wire) throws NoMethodForOperationException {
        Map invocationChains = wire.getInvocationChains();
        HashMap<Method, InvocationChain> chains = new HashMap<Method, InvocationChain>(invocationChains.size());
        for (Map.Entry entry : invocationChains.entrySet()) {
            PhysicalOperationDefinition operation = (PhysicalOperationDefinition)entry.getKey();
            try {
                Method method = this.findMethod(interfaze, operation);
                chains.put(method, (InvocationChain)entry.getValue());
            }
            catch (NoSuchMethodException e) {
                throw new NoMethodForOperationException(operation.getName());
            }
            catch (ClassNotFoundException e) {
                throw new ProxyCreationException((Throwable)e);
            }
        }
        return chains;
    }

    private Method findMethod(Class<?> clazz, PhysicalOperationDefinition operation) throws NoSuchMethodException, ClassNotFoundException {
        String name = operation.getName();
        List params = operation.getParameters();
        Class[] types = new Class[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            types[i] = this.classLoaderRegistry.loadClass(clazz.getClassLoader(), (String)params.get(i));
        }
        return clazz.getMethod(name, types);
    }

    private ScopeContainer<Conversation> getContainer() {
        if (this.conversationalContainer == null) {
            this.conversationalContainer = this.scopeRegistry.getScopeContainer(Scope.CONVERSATION);
        }
        return this.conversationalContainer;
    }
}

