/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.contribution;

import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.ContributionServiceListener;
import org.fabric3.spi.contribution.Import;
import org.fabric3.spi.contribution.manifest.JavaImport;
import org.fabric3.spi.contribution.manifest.PackageInfo;
import org.oasisopen.sca.annotation.Property;

public class HibernateContributionListener
implements ContributionServiceListener {
    private JavaImport hibernateImport;
    private JavaImport javassistImport;
    private boolean noImplicitImport;
    private JavaImport apiImport;

    public HibernateContributionListener() {
        PackageInfo hibernateInfo = new PackageInfo("org.hibernate.*");
        this.hibernateImport = new JavaImport(hibernateInfo);
        PackageInfo javassistInfo = new PackageInfo("javassist.util.proxy");
        this.javassistImport = new JavaImport(javassistInfo);
        PackageInfo apiInfo = new PackageInfo("org.fabric3.jpa.api");
        this.apiImport = new JavaImport(apiInfo);
    }

    @Property(required=false)
    public void setNoImplicitImport(boolean noImplicitImport) {
        this.noImplicitImport = noImplicitImport;
    }

    public void onProcessManifest(Contribution contribution) {
        if (this.noImplicitImport || contribution.getManifest().isExtension()) {
            return;
        }
        boolean jpaImported = false;
        boolean hibernateImported = false;
        boolean javassistImported = false;
        ContributionManifest manifest = contribution.getManifest();
        for (Import imprt : manifest.getImports()) {
            if (!(imprt instanceof JavaImport)) continue;
            JavaImport contributionImport = (JavaImport)imprt;
            String name = contributionImport.getPackageInfo().getName();
            if (name.equals("org.hibernate.*")) {
                hibernateImported = true;
                continue;
            }
            if (name.startsWith("javassist.")) {
                javassistImported = true;
                continue;
            }
            if (!contributionImport.getPackageInfo().getName().startsWith("javax.persistence")) continue;
            jpaImported = true;
        }
        if (jpaImported) {
            if (!hibernateImported) {
                manifest.addImport((Import)this.hibernateImport);
            }
            if (!javassistImported) {
                manifest.addImport((Import)this.javassistImport);
            }
            manifest.addImport((Import)this.apiImport);
        }
    }

    public void onStore(Contribution contribution) {
    }

    public void onInstall(Contribution contribution) {
    }

    public void onUpdate(Contribution contribution) {
    }

    public void onUninstall(Contribution contribution) {
    }

    public void onRemove(Contribution contribution) {
    }
}

