/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.jpa.introspection.InvalidPersistenceContextType;
import org.fabric3.jpa.model.HibernateSessionResourceReference;
import org.fabric3.jpa.model.PersistenceContextResourceReference;
import org.fabric3.model.type.component.ResourceReferenceDefinition;
import org.fabric3.model.type.component.Scope;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class PersistenceContextProcessor
extends AbstractAnnotationProcessor<PersistenceContext> {
    private ServiceContract factoryServiceContract;
    private IntrospectionHelper helper;

    public PersistenceContextProcessor(@Reference JavaContractProcessor contractProcessor, @Reference IntrospectionHelper helper) {
        super(PersistenceContext.class);
        this.helper = helper;
        DefaultIntrospectionContext context = new DefaultIntrospectionContext();
        this.factoryServiceContract = contractProcessor.introspect(EntityManager.class, (IntrospectionContext)context);
        assert (!context.hasErrors());
    }

    public void visitField(PersistenceContext annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        FieldInjectionSite site = new FieldInjectionSite(field);
        String name = this.helper.getSiteName(field, null);
        if (EntityManager.class.equals(field.getType())) {
            PersistenceContextResourceReference definition = this.createDefinition(name, annotation, componentType, context);
            componentType.add((ResourceReferenceDefinition)definition, (InjectionSite)site);
        } else {
            HibernateSessionResourceReference definition = this.createSessionDefinition(name, annotation, componentType);
            componentType.add((ResourceReferenceDefinition)definition, (InjectionSite)site);
        }
        componentType.addRequiredCapability("jpa");
    }

    public void visitMethod(PersistenceContext annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        String name = this.helper.getSiteName(method, null);
        if (EntityManager.class.equals(method.getParameterTypes()[0])) {
            PersistenceContextResourceReference definition = this.createDefinition(name, annotation, componentType, context);
            componentType.add((ResourceReferenceDefinition)definition, (InjectionSite)site);
        } else {
            HibernateSessionResourceReference definition = this.createSessionDefinition(name, annotation, componentType);
            componentType.add((ResourceReferenceDefinition)definition, (InjectionSite)site);
        }
        componentType.addRequiredCapability("jpa");
    }

    private PersistenceContextResourceReference createDefinition(String name, PersistenceContext annotation, InjectingComponentType componentType, IntrospectionContext context) {
        String unitName = annotation.unitName();
        PersistenceContextType type = annotation.type();
        if (PersistenceContextType.EXTENDED == type) {
            InvalidPersistenceContextType error = new InvalidPersistenceContextType("Extended persistence contexts not supported: " + unitName);
            context.addError((ValidationFailure)error);
        }
        boolean multiThreaded = Scope.COMPOSITE.getScope().equals(componentType.getScope());
        return new PersistenceContextResourceReference(name, unitName, this.factoryServiceContract, multiThreaded);
    }

    private HibernateSessionResourceReference createSessionDefinition(String name, PersistenceContext annotation, InjectingComponentType componentType) {
        String unitName = annotation.unitName();
        boolean multiThreaded = Scope.COMPOSITE.getScope().equals(componentType.getScope());
        return new HibernateSessionResourceReference(name, unitName, this.factoryServiceContract, multiThreaded);
    }
}

