/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.fabric3.jpa.model.PersistenceUnitResourceReference;
import org.fabric3.model.type.component.ResourceReferenceDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class PersistenceUnitProcessor
extends AbstractAnnotationProcessor<PersistenceUnit> {
    private final ServiceContract factoryServiceContract;

    public PersistenceUnitProcessor(@Reference JavaContractProcessor contractProcessor) {
        super(PersistenceUnit.class);
        DefaultIntrospectionContext context = new DefaultIntrospectionContext();
        this.factoryServiceContract = contractProcessor.introspect(EntityManagerFactory.class, (IntrospectionContext)context);
        assert (!context.hasErrors());
    }

    public void visitField(PersistenceUnit annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        FieldInjectionSite site = new FieldInjectionSite(field);
        PersistenceUnitResourceReference definition = this.createDefinition(annotation);
        componentType.add((ResourceReferenceDefinition)definition, (InjectionSite)site);
        componentType.addRequiredCapability("jpa");
    }

    public void visitMethod(PersistenceUnit annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        PersistenceUnitResourceReference definition = this.createDefinition(annotation);
        componentType.add((ResourceReferenceDefinition)definition, (InjectionSite)site);
        componentType.addRequiredCapability("jpa");
    }

    PersistenceUnitResourceReference createDefinition(PersistenceUnit annotation) {
        String name = annotation.name();
        String unitName = annotation.unitName();
        return new PersistenceUnitResourceReference(name, unitName, this.factoryServiceContract);
    }
}

