/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.override;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.host.Names;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.jpa.override.OverrideParserMonitor;
import org.fabric3.model.type.ModelObject;
import org.fabric3.spi.event.EventService;
import org.fabric3.spi.event.ExtensionsInitialized;
import org.fabric3.spi.event.Fabric3EventListener;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
@Management
public class SystemConfigOverrideParser
implements Fabric3EventListener<ExtensionsInitialized> {
    private LoaderRegistry loaderRegistry;
    private EventService eventService;
    private OverrideParserMonitor monitor;
    private XMLStreamReader reader;

    public SystemConfigOverrideParser(@Reference LoaderRegistry loaderRegistry, @Reference EventService eventService, @Monitor OverrideParserMonitor monitor) {
        this.loaderRegistry = loaderRegistry;
        this.eventService = eventService;
        this.monitor = monitor;
    }

    @Property(required=false)
    public void setOverrideConfig(XMLStreamReader reader) {
        this.reader = reader;
    }

    @Init
    public void init() {
        this.eventService.subscribe(ExtensionsInitialized.class, (Fabric3EventListener)this);
    }

    @Destroy
    public void destroy() {
        this.eventService.unsubscribe(ExtensionsInitialized.class, (Fabric3EventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(ExtensionsInitialized event) {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.nextTag();
            this.reader.nextTag();
            ClassLoader classLoader = this.getClass().getClassLoader();
            DefaultIntrospectionContext context = new DefaultIntrospectionContext(Names.HOST_CONTRIBUTION, classLoader, null);
            this.loaderRegistry.load(this.reader, ModelObject.class, (IntrospectionContext)context);
            if (context.hasErrors()) {
                List errors = context.getErrors();
                for (ValidationFailure error : errors) {
                    this.monitor.parseError(error.getMessage());
                }
            }
        }
        catch (UnrecognizedElementException e) {
            this.monitor.error(e);
        }
        catch (XMLStreamException e) {
            this.monitor.error(e);
        }
        finally {
            this.close();
        }
    }

    private void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            this.reader = null;
        }
    }
}

