/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime;

import java.net.URI;
import javax.transaction.TransactionManager;
import org.fabric3.jpa.api.EntityManagerFactoryResolver;
import org.fabric3.jpa.api.JpaResolutionException;
import org.fabric3.jpa.api.PersistenceOverrides;
import org.fabric3.jpa.provision.PersistenceContextTargetDefinition;
import org.fabric3.jpa.runtime.proxy.EntityManagerService;
import org.fabric3.jpa.runtime.proxy.MultiThreadedEntityManagerProxyFactory;
import org.fabric3.jpa.runtime.proxy.StatefulEntityManagerProxyFactory;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.wire.Wire;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContextWireAttacher
implements TargetWireAttacher<PersistenceContextTargetDefinition> {
    private EntityManagerFactoryResolver emfResolver;
    private ClassLoaderRegistry registry;
    private TransactionManager tm;
    private EntityManagerService emService;

    public PersistenceContextWireAttacher(@Reference EntityManagerService emService, @Reference TransactionManager tm, @Reference EntityManagerFactoryResolver emfResolver, @Reference ClassLoaderRegistry registry) {
        this.emfResolver = emfResolver;
        this.registry = registry;
        this.emService = emService;
        this.tm = tm;
    }

    public ObjectFactory<?> createObjectFactory(PersistenceContextTargetDefinition definition) throws WiringException {
        String unitName = definition.getUnitName();
        URI classLoaderId = definition.getClassLoaderId();
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = this.registry.getClassLoader(classLoaderId);
            Thread.currentThread().setContextClassLoader(classLoader);
            PersistenceOverrides overrides = definition.getOverrides();
            this.emfResolver.resolve(unitName, overrides, classLoader);
            if (definition.isMultiThreaded()) {
                MultiThreadedEntityManagerProxyFactory multiThreadedEntityManagerProxyFactory = new MultiThreadedEntityManagerProxyFactory(unitName, this.emService, this.tm);
                return multiThreadedEntityManagerProxyFactory;
            }
            StatefulEntityManagerProxyFactory statefulEntityManagerProxyFactory = new StatefulEntityManagerProxyFactory(unitName, this.emService, this.tm);
            return statefulEntityManagerProxyFactory;
        }
        catch (JpaResolutionException e) {
            throw new WiringException((Throwable)((Object)e));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public void attach(PhysicalSourceDefinition source, PersistenceContextTargetDefinition target, Wire wire) throws WiringException {
        throw new UnsupportedOperationException();
    }

    public void detach(PhysicalSourceDefinition source, PersistenceContextTargetDefinition target) throws WiringException {
        throw new UnsupportedOperationException();
    }
}

