/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime;

import java.net.URI;
import javax.persistence.EntityManagerFactory;
import org.fabric3.jpa.api.EntityManagerFactoryResolver;
import org.fabric3.jpa.api.JpaResolutionException;
import org.fabric3.jpa.api.PersistenceOverrides;
import org.fabric3.jpa.provision.PersistenceUnitTargetDefinition;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.objectfactory.SingletonObjectFactory;
import org.fabric3.spi.wire.Wire;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitWireAttacher
implements TargetWireAttacher<PersistenceUnitTargetDefinition> {
    private EntityManagerFactoryResolver emfResolver;
    private ClassLoaderRegistry registry;

    public PersistenceUnitWireAttacher(@Reference EntityManagerFactoryResolver emfResolver, @Reference ClassLoaderRegistry registry) {
        this.emfResolver = emfResolver;
        this.registry = registry;
    }

    public void attach(PhysicalSourceDefinition source, PersistenceUnitTargetDefinition target, Wire wire) throws WiringException {
        throw new AssertionError();
    }

    public void detach(PhysicalSourceDefinition source, PersistenceUnitTargetDefinition target) throws WiringException {
        throw new AssertionError();
    }

    public ObjectFactory<?> createObjectFactory(PersistenceUnitTargetDefinition target) throws WiringException {
        String unitName = target.getUnitName();
        URI classLoaderUri = target.getClassLoaderId();
        ClassLoader classLoader = this.registry.getClassLoader(classLoaderUri);
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            PersistenceOverrides overrides = target.getOverrides();
            EntityManagerFactory entityManagerFactory = this.emfResolver.resolve(unitName, overrides, classLoader);
            SingletonObjectFactory singletonObjectFactory = new SingletonObjectFactory((Object)entityManagerFactory);
            return singletonObjectFactory;
        }
        catch (JpaResolutionException e) {
            throw new WiringException((Throwable)((Object)e));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

