/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime.emf;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.host.Names;
import org.fabric3.jpa.api.EntityManagerFactoryResolver;
import org.fabric3.jpa.api.F3TransactionManagerLookup;
import org.fabric3.jpa.api.JpaResolutionException;
import org.fabric3.jpa.api.PersistenceOverrides;
import org.fabric3.jpa.runtime.emf.EntityManagerFactoryCache;
import org.fabric3.jpa.runtime.emf.PersistenceContextParser;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.fabric3.spi.monitor.MonitorService;
import org.hibernate.ejb.Ejb3Configuration;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class CachingEntityManagerFactoryResolver
implements EntityManagerFactoryResolver {
    private static final String HIBERNATE_LOOKUP = "hibernate.transaction.manager_lookup_class";
    private PersistenceContextParser parser;
    private EntityManagerFactoryCache cache;
    private MonitorService monitorService;
    private MonitorLevel logLevel = MonitorLevel.WARNING;

    @Property(required=false)
    public void setMonitorLevel(String logLevel) {
        this.logLevel = MonitorLevel.valueOf((String)logLevel);
    }

    public CachingEntityManagerFactoryResolver(@Reference PersistenceContextParser parser, @Reference EntityManagerFactoryCache cache, @Reference MonitorService monitorService) {
        this.parser = parser;
        this.cache = cache;
        this.monitorService = monitorService;
    }

    @Init
    public void init() {
        this.monitorService.setProviderLevel("org.hibernate", this.logLevel.toString());
    }

    public synchronized EntityManagerFactory resolve(String unitName, PersistenceOverrides overrides, ClassLoader classLoader) throws JpaResolutionException {
        EntityManagerFactory resolvedEmf = this.cache.get(unitName);
        if (resolvedEmf != null) {
            return resolvedEmf;
        }
        EntityManagerFactory factory = this.createEntityManagerFactory(overrides, classLoader);
        URI key = classLoader instanceof MultiParentClassLoader ? ((MultiParentClassLoader)classLoader).getName() : Names.HOST_CONTRIBUTION;
        this.cache.put(key, unitName, factory);
        return factory;
    }

    private EntityManagerFactory createEntityManagerFactory(PersistenceOverrides overrides, ClassLoader classLoader) throws JpaResolutionException {
        List<PersistenceUnitInfo> infos = this.parser.parse(classLoader);
        String unitName = overrides.getUnitName();
        for (PersistenceUnitInfo info : infos) {
            if (!unitName.equals(info.getPersistenceUnitName())) continue;
            Ejb3Configuration cfg = new Ejb3Configuration();
            DataSource dataSource = info.getJtaDataSource();
            if (dataSource == null) {
                dataSource = info.getNonJtaDataSource();
            }
            cfg.setDataSource(dataSource);
            Properties unitProperties = cfg.getProperties();
            unitProperties.setProperty(HIBERNATE_LOOKUP, F3TransactionManagerLookup.class.getName());
            unitProperties.putAll(overrides.getProperties());
            cfg.configure(info, Collections.emptyMap());
            return cfg.buildEntityManagerFactory();
        }
        throw new JpaResolutionException("Persistence unit not defined for: " + unitName);
    }
}

