/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime.emf;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.host.Names;
import org.fabric3.jpa.api.JpaResolutionException;
import org.fabric3.jpa.runtime.emf.CacheMonitor;
import org.fabric3.jpa.runtime.emf.EntityManagerFactoryCache;
import org.fabric3.spi.builder.classloader.ClassLoaderListener;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.fabric3.spi.management.ManagementException;
import org.fabric3.spi.management.ManagementService;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.jmx.StatisticsService;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

@Service(names={EntityManagerFactoryCache.class, ClassLoaderListener.class})
public class DefaultEntityManagerFactoryCache
implements EntityManagerFactoryCache,
ClassLoaderListener {
    private CacheMonitor monitor;
    private ManagementService managementService;
    private Map<String, EntityManagerFactory> cache = new HashMap<String, EntityManagerFactory>();
    private Map<URI, Set<String>> contributionCache = new HashMap<URI, Set<String>>();

    public DefaultEntityManagerFactoryCache(@Monitor CacheMonitor monitor) {
        this.monitor = monitor;
    }

    @Reference(required=false)
    public void setManagementService(ManagementService managementService) {
        this.managementService = managementService;
    }

    @Destroy
    public void destroy() {
        for (EntityManagerFactory factory : this.cache.values()) {
            if (factory == null) continue;
            factory.close();
        }
    }

    public void onDeploy(ClassLoader loader) {
    }

    public void onUndeploy(ClassLoader classLoader) {
        URI key = classLoader instanceof MultiParentClassLoader ? ((MultiParentClassLoader)classLoader).getName() : Names.BOOT_CONTRIBUTION;
        Set<String> names = this.contributionCache.remove(key);
        if (names != null) {
            for (String name : names) {
                EntityManagerFactory factory = this.cache.remove(name);
                factory.close();
                this.remove(name);
            }
        }
    }

    public EntityManagerFactory get(String unitName) {
        return this.cache.get(unitName);
    }

    public void put(URI uri, String unitName, EntityManagerFactory factory) throws JpaResolutionException {
        if (factory == null) {
            throw new IllegalArgumentException("EntityManagerFactory was null");
        }
        this.cache.put(unitName, factory);
        Set<String> names = this.contributionCache.get(uri);
        if (names == null) {
            names = new HashSet<String>();
            this.contributionCache.put(uri, names);
        }
        names.add(unitName);
        this.export(unitName, factory);
    }

    private void export(String unitName, EntityManagerFactory factory) throws JpaResolutionException {
        if (this.managementService == null) {
            return;
        }
        StatisticsService statistics = new StatisticsService();
        if (!(factory instanceof HibernateEntityManagerFactory)) {
            throw new AssertionError((Object)("Expected " + HibernateEntityManagerFactory.class.getName() + " but was " + factory.getClass().getName()));
        }
        statistics.setSessionFactory(((HibernateEntityManagerFactory)factory).getSessionFactory());
        statistics.setStatisticsEnabled(true);
        try {
            this.managementService.export(this.encodeName(unitName), "Hibernate", "Hibernate session factory MBeans", (Object)statistics);
        }
        catch (ManagementException e) {
            throw new JpaResolutionException("Error exporting management bean for persistence unit: " + unitName, e);
        }
    }

    private void remove(String unitName) {
        if (this.managementService == null) {
            return;
        }
        try {
            this.managementService.remove(this.encodeName(unitName), "Hibernate");
        }
        catch (ManagementException e) {
            this.monitor.error(unitName, e);
        }
    }

    private String encodeName(String name) {
        return "hibernate/sessions/" + name;
    }
}

