/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime.proxy;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.fabric3.jpa.runtime.emf.EntityManagerFactoryCache;
import org.fabric3.jpa.runtime.proxy.EntityManagerCreationException;
import org.fabric3.jpa.runtime.proxy.EntityManagerService;
import org.fabric3.jpa.runtime.proxy.HibernateProxy;
import org.oasisopen.sca.annotation.Reference;

public class EntityManagerServiceImpl
implements EntityManagerService {
    private Map<Key, EntityManager> cache = new ConcurrentHashMap<Key, EntityManager>();
    private EntityManagerFactoryCache emfCache;

    public EntityManagerServiceImpl(@Reference EntityManagerFactoryCache emfCache) {
        this.emfCache = emfCache;
    }

    public EntityManager getEntityManager(String unitName, HibernateProxy proxy, Transaction transaction) throws EntityManagerCreationException {
        Key key = new Key(transaction, unitName);
        EntityManager em = this.cache.get(key);
        if (em == null) {
            EntityManagerFactory emf = this.emfCache.get(unitName);
            if (emf == null) {
                throw new EntityManagerCreationException("No EntityManagerFactory found for persistence unit: " + unitName);
            }
            em = emf.createEntityManager();
            this.registerTransactionScopedSync(proxy, key);
            this.cache.put(key, em);
        }
        return em;
    }

    private void registerTransactionScopedSync(HibernateProxy proxy, Key key) throws EntityManagerCreationException {
        try {
            TransactionScopedSync sync = new TransactionScopedSync(key, proxy);
            key.transaction.registerSynchronization((Synchronization)sync);
        }
        catch (RollbackException e) {
            throw new EntityManagerCreationException(e);
        }
        catch (SystemException e) {
            throw new EntityManagerCreationException(e);
        }
    }

    private class Key {
        private Transaction transaction;
        private String unitName;

        private Key(Transaction transaction, String unitName) {
            this.transaction = transaction;
            this.unitName = unitName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return !(this.transaction == null ? key.transaction != null : !this.transaction.equals(key.transaction)) && !(this.unitName == null ? key.unitName != null : !this.unitName.equals(key.unitName));
        }

        public int hashCode() {
            int result = this.transaction != null ? this.transaction.hashCode() : 0;
            result = 31 * result + (this.unitName != null ? this.unitName.hashCode() : 0);
            return result;
        }
    }

    private class TransactionScopedSync
    implements Synchronization {
        private Key key;
        private HibernateProxy proxy;

        private TransactionScopedSync(Key key, HibernateProxy proxy) {
            this.key = key;
            this.proxy = proxy;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.proxy.clearEntityManager();
            EntityManager manager = (EntityManager)EntityManagerServiceImpl.this.cache.remove(this.key);
            manager.close();
        }
    }
}

