/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime.proxy;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.fabric3.jpa.runtime.proxy.EntityManagerCreationException;
import org.fabric3.jpa.runtime.proxy.EntityManagerService;
import org.fabric3.jpa.runtime.proxy.HibernateProxy;
import org.oasisopen.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiThreadedEntityManagerProxy
implements HibernateProxy,
EntityManager {
    private String unitName;
    private EntityManagerService emService;
    private TransactionManager tm;

    public MultiThreadedEntityManagerProxy(String unitName, EntityManagerService emService, TransactionManager tm) {
        this.unitName = unitName;
        this.emService = emService;
        this.tm = tm;
    }

    public void persist(Object entity) {
        this.getEntityManager().persist(entity);
    }

    public <T> T merge(T entity) {
        return (T)this.getEntityManager().merge(entity);
    }

    public void remove(Object entity) {
        this.getEntityManager().remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.getEntityManager().find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> tClass, Object o, Map<String, Object> stringObjectMap) {
        return (T)this.getEntityManager().find(tClass, o, stringObjectMap);
    }

    public <T> T find(Class<T> tClass, Object o, LockModeType lockModeType) {
        return (T)this.getEntityManager().find(tClass, o, lockModeType);
    }

    public <T> T find(Class<T> tClass, Object o, LockModeType lockModeType, Map<String, Object> stringObjectMap) {
        return (T)this.getEntityManager().find(tClass, o, lockModeType, stringObjectMap);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.getEntityManager().getReference(entityClass, primaryKey);
    }

    public void flush() {
        this.getEntityManager().flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.getEntityManager().setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.getEntityManager().getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.getEntityManager().lock(entity, lockMode);
    }

    public void lock(Object o, LockModeType lockModeType, Map<String, Object> stringObjectMap) {
        this.getEntityManager().lock(o, lockModeType, stringObjectMap);
    }

    public void refresh(Object entity) {
        this.getEntityManager().remove(entity);
    }

    public void refresh(Object o, Map<String, Object> stringObjectMap) {
        this.getEntityManager().refresh(o, stringObjectMap);
    }

    public void refresh(Object o, LockModeType lockModeType) {
        this.getEntityManager().refresh(o, lockModeType);
    }

    public void refresh(Object o, LockModeType lockModeType, Map<String, Object> stringObjectMap) {
        this.getEntityManager().refresh(o, lockModeType, stringObjectMap);
    }

    public void clear() {
        this.getEntityManager().clear();
    }

    public void detach(Object o) {
        this.getEntityManager().detach(o);
    }

    public boolean contains(Object entity) {
        return this.getEntityManager().contains(entity);
    }

    public LockModeType getLockMode(Object o) {
        return this.getEntityManager().getLockMode(o);
    }

    public void setProperty(String s, Object o) {
        this.getEntityManager().setProperty(s, o);
    }

    public Map<String, Object> getProperties() {
        return this.getEntityManager().getProperties();
    }

    public Query createQuery(String qlString) {
        return this.getEntityManager().createQuery(qlString);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> tCriteriaQuery) {
        return this.getEntityManager().createQuery(tCriteriaQuery);
    }

    public <T> TypedQuery<T> createQuery(String s, Class<T> tClass) {
        return this.getEntityManager().createQuery(s, tClass);
    }

    public Query createNamedQuery(String name) {
        return this.getEntityManager().createNamedQuery(name);
    }

    public <T> TypedQuery<T> createNamedQuery(String s, Class<T> tClass) {
        return this.getEntityManager().createNamedQuery(s, tClass);
    }

    public Query createNativeQuery(String sqlString) {
        return this.getEntityManager().createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.getEntityManager().createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.getEntityManager().createNativeQuery(sqlString, resultSetMapping);
    }

    public void joinTransaction() {
        this.getEntityManager().joinTransaction();
    }

    public <T> T unwrap(Class<T> tClass) {
        return (T)this.getEntityManager().unwrap(tClass);
    }

    public Object getDelegate() {
        return this.getEntityManager().getDelegate();
    }

    public void close() {
        this.getEntityManager().close();
    }

    public boolean isOpen() {
        return this.getEntityManager().isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.getEntityManager().getTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.getEntityManager().getEntityManagerFactory();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getEntityManager().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.getEntityManager().getMetamodel();
    }

    @Override
    public void clearEntityManager() {
    }

    private EntityManager getEntityManager() {
        try {
            Transaction trx = this.tm.getTransaction();
            if (trx == null) {
                throw new IllegalStateException("A transaction is not active - ensure the component is executing in a managed transaction");
            }
            return this.emService.getEntityManager(this.unitName, this, trx);
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (EntityManagerCreationException e) {
            throw new ServiceRuntimeException((Throwable)((Object)e));
        }
    }
}

