/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime.proxy;

import java.io.Serializable;
import java.sql.Connection;
import javax.persistence.EntityManager;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.fabric3.jpa.runtime.proxy.EntityManagerCreationException;
import org.fabric3.jpa.runtime.proxy.EntityManagerService;
import org.fabric3.jpa.runtime.proxy.HibernateProxy;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.UnknownProfileException;
import org.hibernate.jdbc.Work;
import org.hibernate.stat.SessionStatistics;
import org.oasisopen.sca.ServiceRuntimeException;

public class MultiThreadedSessionProxy
implements Session,
HibernateProxy {
    private static final long serialVersionUID = -4143261157740097948L;
    private String unitName;
    private EntityManagerService emService;
    private TransactionManager tm;

    public MultiThreadedSessionProxy(String unitName, EntityManagerService emService, TransactionManager tm) {
        this.unitName = unitName;
        this.emService = emService;
        this.tm = tm;
    }

    public void persist(Object entity) {
        this.getSession().persist(entity);
    }

    public void flush() {
        this.getSession().flush();
    }

    public EntityMode getEntityMode() {
        return this.getSession().getEntityMode();
    }

    public Session getSession(EntityMode entityMode) {
        return this.getSession().getSession(entityMode);
    }

    public void setFlushMode(FlushMode flushMode) {
        this.getSession().setFlushMode(flushMode);
    }

    public FlushMode getFlushMode() {
        return this.getSession().getFlushMode();
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.getSession().setCacheMode(cacheMode);
    }

    public CacheMode getCacheMode() {
        return this.getSession().getCacheMode();
    }

    public SessionFactory getSessionFactory() {
        return this.getSession().getSessionFactory();
    }

    public Connection connection() throws HibernateException {
        return this.getSession().connection();
    }

    public Connection close() throws HibernateException {
        return this.getSession().close();
    }

    public void cancelQuery() throws HibernateException {
        this.getSession().cancelQuery();
    }

    public boolean isOpen() {
        return this.getSession().isOpen();
    }

    public boolean isConnected() {
        return this.getSession().isConnected();
    }

    public boolean isDirty() throws HibernateException {
        return this.getSession().isDirty();
    }

    public boolean isDefaultReadOnly() {
        return this.getSession().isDefaultReadOnly();
    }

    public void setDefaultReadOnly(boolean b) {
        this.getSession().setDefaultReadOnly(b);
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        return this.getSession().getIdentifier(object);
    }

    public boolean contains(Object object) {
        return this.getSession().contains(object);
    }

    public void evict(Object object) throws HibernateException {
        this.getSession().evict(object);
    }

    public Object load(Class theClass, Serializable id, LockMode lockMode) throws HibernateException {
        return this.getSession().load(theClass, id, lockMode);
    }

    public Object load(Class aClass, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        return this.getSession().load(aClass, serializable, lockOptions);
    }

    public Object load(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.getSession().load(entityName, id, lockMode);
    }

    public Object load(String s, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        return this.getSession().load(s, serializable, lockOptions);
    }

    public Object load(Class theClass, Serializable id) throws HibernateException {
        return this.getSession().load(theClass, id);
    }

    public Object load(String entityName, Serializable id) throws HibernateException {
        return this.getSession().load(entityName, id);
    }

    public void load(Object object, Serializable id) throws HibernateException {
        this.getSession().load(object, id);
    }

    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        this.getSession().replicate(object, replicationMode);
    }

    public void replicate(String entityName, Object object, ReplicationMode replicationMode) throws HibernateException {
        this.getSession().replicate(entityName, object, replicationMode);
    }

    public Serializable save(Object object) throws HibernateException {
        return this.getSession().save(object);
    }

    public Serializable save(String entityName, Object object) throws HibernateException {
        return this.getSession().save(entityName, object);
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        this.getSession().saveOrUpdate(object);
    }

    public void saveOrUpdate(String entityName, Object object) throws HibernateException {
        this.getSession().saveOrUpdate(entityName, object);
    }

    public void update(Object object) throws HibernateException {
        this.getSession().update(object);
    }

    public void update(String entityName, Object object) throws HibernateException {
        this.getSession().update(entityName, object);
    }

    public Object merge(Object object) throws HibernateException {
        return this.getSession().merge(object);
    }

    public Object merge(String entityName, Object object) throws HibernateException {
        return this.getSession().merge(entityName, object);
    }

    public void persist(String entityName, Object object) throws HibernateException {
        this.getSession().persist(entityName, object);
    }

    public void delete(Object object) throws HibernateException {
        this.getSession().delete(object);
    }

    public void delete(String entityName, Object object) throws HibernateException {
        this.getSession().delete(entityName, object);
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.getSession().lock(object, lockMode);
    }

    public void lock(String entityName, Object object, LockMode lockMode) throws HibernateException {
        this.getSession().lock(entityName, object, lockMode);
    }

    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        return this.getSession().buildLockRequest(lockOptions);
    }

    public void refresh(Object object) throws HibernateException {
        this.getSession().refresh(object);
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.getSession().refresh(object, lockMode);
    }

    public void refresh(Object o, LockOptions lockOptions) throws HibernateException {
        this.getSession().refresh(o, lockOptions);
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        return this.getSession().getCurrentLockMode(object);
    }

    public org.hibernate.Transaction beginTransaction() throws HibernateException {
        return this.getSession().beginTransaction();
    }

    public org.hibernate.Transaction getTransaction() {
        return this.getSession().getTransaction();
    }

    public Criteria createCriteria(Class persistentClass) {
        return this.getSession().createCriteria(persistentClass);
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        return this.getSession().createCriteria(persistentClass, alias);
    }

    public Criteria createCriteria(String entityName) {
        return this.getSession().createCriteria(entityName);
    }

    public Criteria createCriteria(String entityName, String alias) {
        return this.getSession().createCriteria(entityName, alias);
    }

    public Query createQuery(String queryString) throws HibernateException {
        return this.getSession().createQuery(queryString);
    }

    public SQLQuery createSQLQuery(String queryString) throws HibernateException {
        return this.getSession().createSQLQuery(queryString);
    }

    public Query createFilter(Object collection, String queryString) throws HibernateException {
        return this.getSession().createFilter(collection, queryString);
    }

    public Query getNamedQuery(String queryName) throws HibernateException {
        return this.getSession().getNamedQuery(queryName);
    }

    public void clear() {
        this.getSession().clear();
    }

    public Object get(Class clazz, Serializable id) throws HibernateException {
        return this.getSession().get(clazz, id);
    }

    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        return this.getSession().get(clazz, id, lockMode);
    }

    public Object get(Class aClass, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        return this.getSession().get(aClass, serializable, lockOptions);
    }

    public Object get(String entityName, Serializable id) throws HibernateException {
        return this.getSession().get(entityName, id);
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.getSession().get(entityName, id, lockMode);
    }

    public Object get(String s, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        return this.getSession().get(s, serializable, lockOptions);
    }

    public String getEntityName(Object object) throws HibernateException {
        return this.getSession().getEntityName(object);
    }

    public Filter enableFilter(String filterName) {
        return this.getSession().enableFilter(filterName);
    }

    public Filter getEnabledFilter(String filterName) {
        return this.getSession().getEnabledFilter(filterName);
    }

    public void disableFilter(String filterName) {
        this.getSession().disableFilter(filterName);
    }

    public SessionStatistics getStatistics() {
        return this.getSession().getStatistics();
    }

    public boolean isReadOnly(Object o) {
        return this.getSession().isReadOnly(o);
    }

    public void setReadOnly(Object entity, boolean readOnly) {
        this.getSession().setReadOnly(entity, readOnly);
    }

    public void doWork(Work work) throws HibernateException {
        this.getSession().doWork(work);
    }

    public Connection disconnect() throws HibernateException {
        return this.getSession().disconnect();
    }

    public void reconnect() throws HibernateException {
        this.getSession().reconnect();
    }

    public void reconnect(Connection connection) throws HibernateException {
        this.getSession().reconnect(connection);
    }

    public boolean isFetchProfileEnabled(String s) throws UnknownProfileException {
        return this.getSession().isFetchProfileEnabled(s);
    }

    public void enableFetchProfile(String s) throws UnknownProfileException {
        this.getSession().enableFetchProfile(s);
    }

    public void disableFetchProfile(String s) throws UnknownProfileException {
        this.getSession().disableFetchProfile(s);
    }

    private Session getSession() {
        try {
            Transaction trx = this.tm.getTransaction();
            if (trx == null) {
                throw new IllegalStateException("A transaction is not active - ensure the component is executing in a managed transaction");
            }
            EntityManager em = this.emService.getEntityManager(this.unitName, this, trx);
            return (Session)em.getDelegate();
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (EntityManagerCreationException e) {
            throw new ServiceRuntimeException((Throwable)((Object)e));
        }
    }

    public void clearEntityManager() {
    }
}

