/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime.proxy;

import java.io.Serializable;
import java.sql.Connection;
import javax.persistence.EntityManager;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.fabric3.jpa.runtime.proxy.EntityManagerCreationException;
import org.fabric3.jpa.runtime.proxy.EntityManagerService;
import org.fabric3.jpa.runtime.proxy.HibernateProxy;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.UnknownProfileException;
import org.hibernate.jdbc.Work;
import org.hibernate.stat.SessionStatistics;
import org.oasisopen.sca.ServiceRuntimeException;

public class StatefulSessionProxy
implements Session,
HibernateProxy {
    private static final long serialVersionUID = 1955430345975268500L;
    private String unitName;
    private EntityManagerService emService;
    private TransactionManager tm;
    private Session session;

    public StatefulSessionProxy(String unitName, EntityManagerService emService, TransactionManager tm) {
        this.unitName = unitName;
        this.emService = emService;
        this.tm = tm;
    }

    public void persist(Object entity) {
        this.initSession();
        this.session.persist(entity);
    }

    public void flush() {
        this.initSession();
        this.session.flush();
    }

    public EntityMode getEntityMode() {
        this.initSession();
        return this.session.getEntityMode();
    }

    public Session getSession(EntityMode entityMode) {
        this.initSession();
        return this.session.getSession(entityMode);
    }

    public void setFlushMode(FlushMode flushMode) {
        this.initSession();
        this.session.setFlushMode(flushMode);
    }

    public FlushMode getFlushMode() {
        this.initSession();
        return this.session.getFlushMode();
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.initSession();
        this.session.setCacheMode(cacheMode);
    }

    public CacheMode getCacheMode() {
        this.initSession();
        return this.session.getCacheMode();
    }

    public SessionFactory getSessionFactory() {
        this.initSession();
        return this.session.getSessionFactory();
    }

    public Connection connection() throws HibernateException {
        this.initSession();
        return this.session.connection();
    }

    public Connection close() throws HibernateException {
        this.initSession();
        return this.session.close();
    }

    public void cancelQuery() throws HibernateException {
        this.initSession();
        this.session.cancelQuery();
    }

    public boolean isOpen() {
        this.initSession();
        return this.session.isOpen();
    }

    public boolean isConnected() {
        this.initSession();
        return this.session.isConnected();
    }

    public boolean isDirty() throws HibernateException {
        this.initSession();
        return this.session.isDirty();
    }

    public boolean isDefaultReadOnly() {
        this.initSession();
        return this.session.isDefaultReadOnly();
    }

    public void setDefaultReadOnly(boolean read) {
        this.initSession();
        this.session.setDefaultReadOnly(read);
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        this.initSession();
        return this.session.getIdentifier(object);
    }

    public boolean contains(Object object) {
        this.initSession();
        return this.session.contains(object);
    }

    public void evict(Object object) throws HibernateException {
        this.initSession();
        this.session.evict(object);
    }

    public Object load(Class theClass, Serializable id, LockMode lockMode) throws HibernateException {
        this.initSession();
        return this.session.load(theClass, id, lockMode);
    }

    public Object load(Class aClass, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        this.initSession();
        return this.session.load(aClass, serializable, lockOptions);
    }

    public Object load(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        this.initSession();
        return this.session.load(entityName, id, lockMode);
    }

    public Object load(String s, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        this.initSession();
        return this.session.load(s, serializable, lockOptions);
    }

    public Object load(Class theClass, Serializable id) throws HibernateException {
        this.initSession();
        return this.session.load(theClass, id);
    }

    public Object load(String entityName, Serializable id) throws HibernateException {
        this.initSession();
        return this.session.load(entityName, id);
    }

    public void load(Object object, Serializable id) throws HibernateException {
        this.initSession();
        this.session.load(object, id);
    }

    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        this.initSession();
        this.session.replicate(object, replicationMode);
    }

    public void replicate(String entityName, Object object, ReplicationMode replicationMode) throws HibernateException {
        this.initSession();
        this.session.replicate(entityName, object, replicationMode);
    }

    public Serializable save(Object object) throws HibernateException {
        this.initSession();
        return this.session.save(object);
    }

    public Serializable save(String entityName, Object object) throws HibernateException {
        this.initSession();
        return this.session.save(entityName, object);
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        this.initSession();
        this.session.saveOrUpdate(object);
    }

    public void saveOrUpdate(String entityName, Object object) throws HibernateException {
        this.initSession();
        this.session.saveOrUpdate(entityName, object);
    }

    public void update(Object object) throws HibernateException {
        this.initSession();
        this.session.update(object);
    }

    public void update(String entityName, Object object) throws HibernateException {
        this.initSession();
        this.session.update(entityName, object);
    }

    public Object merge(Object object) throws HibernateException {
        this.initSession();
        return this.session.merge(object);
    }

    public Object merge(String entityName, Object object) throws HibernateException {
        this.initSession();
        return this.session.merge(entityName, object);
    }

    public void persist(String entityName, Object object) throws HibernateException {
        this.initSession();
        this.session.persist(entityName, object);
    }

    public void delete(Object object) throws HibernateException {
        this.initSession();
        this.session.delete(object);
    }

    public void delete(String entityName, Object object) throws HibernateException {
        this.initSession();
        this.session.delete(entityName, object);
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.initSession();
        this.session.lock(object, lockMode);
    }

    public void lock(String entityName, Object object, LockMode lockMode) throws HibernateException {
        this.initSession();
        this.session.lock(entityName, object, lockMode);
    }

    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        this.initSession();
        return this.session.buildLockRequest(lockOptions);
    }

    public void refresh(Object object) throws HibernateException {
        this.initSession();
        this.session.refresh(object);
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.initSession();
        this.session.refresh(object, lockMode);
    }

    public void refresh(Object o, LockOptions lockOptions) throws HibernateException {
        this.initSession();
        this.session.refresh(o, lockOptions);
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        this.initSession();
        return this.session.getCurrentLockMode(object);
    }

    public org.hibernate.Transaction beginTransaction() throws HibernateException {
        this.initSession();
        return this.session.beginTransaction();
    }

    public org.hibernate.Transaction getTransaction() {
        this.initSession();
        return this.session.getTransaction();
    }

    public Criteria createCriteria(Class persistentClass) {
        this.initSession();
        return this.session.createCriteria(persistentClass);
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        this.initSession();
        return this.session.createCriteria(persistentClass, alias);
    }

    public Criteria createCriteria(String entityName) {
        this.initSession();
        return this.session.createCriteria(entityName);
    }

    public Criteria createCriteria(String entityName, String alias) {
        this.initSession();
        return this.session.createCriteria(entityName, alias);
    }

    public Query createQuery(String queryString) throws HibernateException {
        this.initSession();
        return this.session.createQuery(queryString);
    }

    public SQLQuery createSQLQuery(String queryString) throws HibernateException {
        this.initSession();
        return this.session.createSQLQuery(queryString);
    }

    public Query createFilter(Object collection, String queryString) throws HibernateException {
        this.initSession();
        return this.session.createFilter(collection, queryString);
    }

    public Query getNamedQuery(String queryName) throws HibernateException {
        this.initSession();
        return this.session.getNamedQuery(queryName);
    }

    public void clear() {
        this.initSession();
        this.session.clear();
    }

    public Object get(Class clazz, Serializable id) throws HibernateException {
        this.initSession();
        return this.session.get(clazz, id);
    }

    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        this.initSession();
        return this.session.get(clazz, id, lockMode);
    }

    public Object get(Class aClass, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        this.initSession();
        return this.session.get(aClass, serializable, lockOptions);
    }

    public Object get(String entityName, Serializable id) throws HibernateException {
        this.initSession();
        return this.session.get(entityName, id);
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        this.initSession();
        return this.session.get(entityName, id, lockMode);
    }

    public Object get(String s, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        this.initSession();
        return this.session.get(s, serializable, lockOptions);
    }

    public String getEntityName(Object object) throws HibernateException {
        this.initSession();
        return this.session.getEntityName(object);
    }

    public Filter enableFilter(String filterName) {
        this.initSession();
        return this.session.enableFilter(filterName);
    }

    public Filter getEnabledFilter(String filterName) {
        this.initSession();
        return this.session.getEnabledFilter(filterName);
    }

    public void disableFilter(String filterName) {
        this.initSession();
        this.session.disableFilter(filterName);
    }

    public SessionStatistics getStatistics() {
        this.initSession();
        return this.session.getStatistics();
    }

    public boolean isReadOnly(Object o) {
        this.initSession();
        return this.session.isReadOnly(o);
    }

    public void setReadOnly(Object entity, boolean readOnly) {
        this.initSession();
        this.session.setReadOnly(entity, readOnly);
    }

    public void doWork(Work work) throws HibernateException {
        this.initSession();
        this.session.doWork(work);
    }

    public Connection disconnect() throws HibernateException {
        this.initSession();
        return this.session.disconnect();
    }

    public void reconnect() throws HibernateException {
        this.initSession();
        this.session.reconnect();
    }

    public void reconnect(Connection connection) throws HibernateException {
        this.initSession();
        this.session.reconnect(connection);
    }

    public boolean isFetchProfileEnabled(String s) throws UnknownProfileException {
        this.initSession();
        return this.session.isFetchProfileEnabled(s);
    }

    public void enableFetchProfile(String s) throws UnknownProfileException {
        this.initSession();
        this.session.enableFetchProfile(s);
    }

    public void disableFetchProfile(String s) throws UnknownProfileException {
        this.initSession();
        this.session.disableFetchProfile(s);
    }

    public void clearEntityManager() {
        this.session = null;
    }

    private void initSession() {
        if (this.session != null) {
            return;
        }
        try {
            Transaction trx = this.tm.getTransaction();
            if (trx == null) {
                throw new IllegalStateException("A transaction is not active - ensure the component is executing in a managed transaction");
            }
            EntityManager em = this.emService.getEntityManager(this.unitName, this, trx);
            this.session = (Session)em.getDelegate();
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (EntityManagerCreationException e) {
            throw new ServiceRuntimeException((Throwable)((Object)e));
        }
    }
}

