/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.loader;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.binding.ws.model.WsBindingDefinition;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class WsBindingLoader
implements TypeLoader<WsBindingDefinition> {
    private static final Map<String, String> ATTRIBUTES = new HashMap<String, String>();
    private final LoaderHelper loaderHelper;

    public WsBindingLoader(@Reference LoaderHelper loaderHelper) {
        this.loaderHelper = loaderHelper;
    }

    public WsBindingDefinition load(XMLStreamReader reader, IntrospectionContext introspectionContext) throws XMLStreamException {
        this.validateAttributes(reader, introspectionContext);
        WsBindingDefinition binding = null;
        String uri = null;
        try {
            uri = reader.getAttributeValue(null, "uri");
            String wsdlElement = reader.getAttributeValue(null, "wsdlElement");
            String wsdlLocation = reader.getAttributeValue("http://www.w3.org/2004/08/wsdl-instance", "wsdlLocation");
            String bindingName = reader.getAttributeValue(null, "name");
            if (uri == null) {
                binding = new WsBindingDefinition(bindingName, null, wsdlLocation, wsdlElement);
            } else {
                URI targetUri = new URI(uri);
                binding = new WsBindingDefinition(bindingName, targetUri, wsdlLocation, wsdlElement);
            }
            this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)binding, reader, introspectionContext);
            this.loadConfig(binding, reader);
        }
        catch (URISyntaxException ex) {
            InvalidValue failure = new InvalidValue("The web services binding URI is not a valid: " + uri, reader);
            introspectionContext.addError((ValidationFailure)failure);
        }
        return binding;
    }

    private void loadConfig(WsBindingDefinition bd, XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, String> configuration = null;
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String name = reader.getName().getLocalPart();
                    if ("configuration".equals(name)) {
                        configuration = new HashMap<String, String>();
                        break;
                    }
                    if (configuration == null) break;
                    String value = reader.getElementText();
                    configuration.put(name, value);
                    break;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if ("configuration".equals(name)) {
                        bd.setConfiguration(configuration);
                        break;
                    }
                    if (!"binding.ws".equals(name)) break;
                    return;
                }
            }
        }
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if (ATTRIBUTES.containsKey(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }

    static {
        ATTRIBUTES.put("uri", "uri");
        ATTRIBUTES.put("impl", "impl");
        ATTRIBUTES.put("wsdlElement", "wsdlElement");
        ATTRIBUTES.put("wsdlLocation", "wsdlLocation");
        ATTRIBUTES.put("requires", "requires");
        ATTRIBUTES.put("policySets", "policySets");
        ATTRIBUTES.put("name", "name");
    }
}

