/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.Multiplicity;
import org.fabric3.model.type.component.Target;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidPrefixException;
import org.fabric3.spi.introspection.xml.InvalidQNamePrefix;
import org.fabric3.spi.introspection.xml.InvalidTargetException;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLoaderHelper
implements LoaderHelper {
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public DefaultLoaderHelper() {
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    public String loadKey(XMLStreamReader reader) {
        String key = reader.getAttributeValue("urn:fabric3.org:core", "key");
        if (key == null) {
            return null;
        }
        int index = key.indexOf(58);
        if (index != -1 && !key.startsWith("{")) {
            String prefix = key.substring(0, index);
            String localPart = key.substring(index + 1);
            String ns = reader.getNamespaceContext().getNamespaceURI(prefix);
            key = "{" + ns + "}" + localPart;
        }
        return key;
    }

    public void loadPolicySetsAndIntents(PolicyAware policyAware, XMLStreamReader reader, IntrospectionContext context) {
        try {
            policyAware.setIntents(this.parseListOfQNames(reader, "requires"));
            policyAware.setPolicySets(this.parseListOfQNames(reader, "policySets"));
        }
        catch (InvalidPrefixException e) {
            String prefix = e.getPrefix();
            URI uri = context.getContributionUri();
            context.addError((ValidationFailure)new InvalidQNamePrefix("The prefix " + prefix + " specified in contribution " + uri + " is invalid", reader));
        }
    }

    public Set<QName> parseListOfQNames(XMLStreamReader reader, String attribute) throws InvalidPrefixException {
        HashSet<QName> qNames = new HashSet<QName>();
        String val = reader.getAttributeValue(null, attribute);
        if (val != null) {
            StringTokenizer tok = new StringTokenizer(val);
            while (tok.hasMoreElements()) {
                qNames.add(this.createQName(tok.nextToken(), reader));
            }
        }
        return qNames;
    }

    public QName createQName(String name, XMLStreamReader reader) throws InvalidPrefixException {
        QName qName;
        int index = name.indexOf(58);
        if (index != -1) {
            String prefix = name.substring(0, index);
            String localPart = name.substring(index + 1);
            String ns = reader.getNamespaceContext().getNamespaceURI(prefix);
            if (ns == null) {
                throw new InvalidPrefixException("Invalid prefix: " + prefix, prefix, reader);
            }
            qName = new QName(ns, localPart, prefix);
        } else {
            String prefix = "";
            String ns = reader.getNamespaceURI();
            qName = new QName(ns, name, prefix);
        }
        return qName;
    }

    public URI parseUri(String target) throws URISyntaxException {
        if (target == null) {
            return null;
        }
        int index = target.lastIndexOf(47);
        if (index == -1) {
            return new URI(target);
        }
        String uri = target.substring(0, index);
        String fragment = target.substring(index + 1);
        return new URI(uri + '#' + fragment);
    }

    public Target parseTarget(String target, XMLStreamReader reader) throws InvalidTargetException {
        if (target == null) {
            return null;
        }
        String[] tokens = target.split("/");
        if (tokens.length == 1) {
            return new Target(tokens[0]);
        }
        if (tokens.length == 2) {
            return new Target(tokens[0], tokens[1]);
        }
        if (tokens.length == 3) {
            return new Target(tokens[0], tokens[1], tokens[2]);
        }
        throw new InvalidTargetException("Invalid target format: " + target, target, reader);
    }

    public List<URI> parseListOfUris(XMLStreamReader reader, String attribute) throws URISyntaxException {
        String value = reader.getAttributeValue(null, attribute);
        if (value == null || value.length() == 0) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(value);
        ArrayList<URI> result = new ArrayList<URI>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            result.add(this.parseUri(tok.nextToken().trim()));
        }
        return result;
    }

    public boolean canNarrow(Multiplicity first, Multiplicity second) {
        switch (second) {
            case ONE_ONE: {
                return Multiplicity.ONE_ONE == first;
            }
            case ONE_N: {
                return Multiplicity.ONE_ONE == first || Multiplicity.ONE_N == first;
            }
            case ZERO_N: {
                return true;
            }
            case ZERO_ONE: {
                return Multiplicity.ONE_ONE == first || Multiplicity.ZERO_ONE == first;
            }
        }
        return false;
    }

    public Document loadPropertyValues(XMLStreamReader reader) throws XMLStreamException {
        DocumentBuilder builder;
        try {
            builder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        int depth = 0;
        Document document = builder.newDocument();
        Element root = document.createElementNS("", "values");
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            root.setAttributeNS(reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
        this.populateNamespaces(reader, root);
        document.appendChild(root);
        Node element = root;
        block8: while (true) {
            int next = reader.next();
            switch (next) {
                case 1: {
                    String namespace = reader.getNamespaceURI();
                    String name = reader.getLocalName();
                    if (depth == 0 && !"value".equals(name)) {
                        element = document.getDocumentElement();
                    }
                    Element child = document.createElementNS(namespace, name);
                    if (element != null) {
                        element.appendChild(child);
                    } else {
                        document.appendChild(child);
                    }
                    element = child;
                    ++depth;
                    break;
                }
                case 4: 
                case 12: {
                    String value = reader.getText();
                    if (value.trim().length() == 0) continue block8;
                    if (depth == 0) {
                        element = document.createElement("value");
                        root.appendChild(element);
                    }
                    Text text = document.createTextNode(value);
                    element.appendChild(text);
                    break;
                }
                case 2: {
                    QName elementName = reader.getName();
                    String localPart = elementName.getLocalPart();
                    String ns = elementName.getNamespaceURI();
                    if (localPart.equals("property") && ("".equals(ns) || "http://docs.oasis-open.org/ns/opencsa/sca/200912".equals(ns))) {
                        return document;
                    }
                    element = --depth == 0 ? root : element.getParentNode();
                }
            }
        }
    }

    public Document loadPropertyValue(String content, XMLStreamReader reader) throws XMLStreamException {
        DocumentBuilder builder;
        try {
            builder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        Document document = builder.newDocument();
        Element root = document.createElement("values");
        document.appendChild(root);
        Element element = document.createElement("value");
        root.appendChild(element);
        Text text = document.createTextNode(content);
        element.appendChild(text);
        return document;
    }

    public Document transform(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() != 1) {
            throw new XMLStreamException("The stream needs to be at the start of an element");
        }
        DocumentBuilder builder = this.getDocumentBuilder();
        Document document = builder.newDocument();
        QName rootName = reader.getName();
        Element root = this.createElement(reader, document, rootName);
        document.appendChild(root);
        while (true) {
            int next = reader.next();
            switch (next) {
                case 1: {
                    QName childName = new QName(reader.getNamespaceURI(), reader.getLocalName());
                    Element child = this.createElement(reader, document, childName);
                    root.appendChild(child);
                    root = child;
                    break;
                }
                case 4: 
                case 12: {
                    Text text = document.createTextNode(reader.getText());
                    root.appendChild(text);
                    break;
                }
                case 2: {
                    if (rootName.equals(reader.getName())) {
                        return document;
                    }
                    root = (Element)root.getParentNode();
                }
            }
        }
    }

    private void populateNamespaces(XMLStreamReader reader, Element element) {
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            String prefix = reader.getNamespacePrefix(i);
            String uri = reader.getNamespaceURI(i);
            prefix = prefix == null ? "xmlns" : "xmlns:" + prefix;
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", prefix, uri);
        }
    }

    private DocumentBuilder getDocumentBuilder() throws XMLStreamException {
        try {
            return this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XMLStreamException(e);
        }
    }

    private Element createElement(XMLStreamReader reader, Document document, QName rootName) {
        int i;
        Element root = document.createElementNS(rootName.getNamespaceURI(), rootName.getLocalPart());
        for (i = 0; i < reader.getNamespaceCount(); ++i) {
            String prefix = reader.getNamespacePrefix(i);
            String uri = reader.getNamespaceURI(i);
            prefix = prefix == null ? "xmlns" : "xmlns:" + prefix;
            root.setAttribute(prefix, uri);
        }
        for (i = 0; i < reader.getAttributeCount(); ++i) {
            String attributeNs = reader.getAttributeNamespace(i);
            String localName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            String attributePrefix = reader.getAttributePrefix(i);
            String qualifiedName = attributePrefix == null ? localName : attributePrefix + ":" + localName;
            root.setAttributeNS(attributeNs, qualifiedName, value);
        }
        return root;
    }
}

