/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.common;

import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.common.BindingNameNotConfigured;
import org.fabric3.introspection.xml.common.InvalidBindingName;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.spi.introspection.IntrospectionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingHelper {
    public static void configureName(BindingDefinition binding, String defaultName, List<BindingDefinition> bindings, XMLStreamReader reader, IntrospectionContext context) {
        for (BindingDefinition entry : bindings) {
            if (!defaultName.equals(entry.getName())) continue;
            BindingNameNotConfigured error = new BindingNameNotConfigured(defaultName, reader);
            context.addError((ValidationFailure)error);
            return;
        }
        binding.setName(defaultName);
    }

    public static boolean checkDuplicateNames(BindingDefinition binding, List<BindingDefinition> bindings, XMLStreamReader reader, IntrospectionContext context) {
        for (BindingDefinition definition : bindings) {
            String bindingName = definition.getName();
            if (!bindingName.equals(binding.getName())) continue;
            InvalidBindingName error = new InvalidBindingName("Duplicate binding named " + bindingName, reader);
            context.addError((ValidationFailure)error);
            return false;
        }
        return true;
    }
}

