/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.introspection.xml.common.MissingProducerName;
import org.fabric3.model.type.ModelObject;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.ComponentConsumer;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentConsumerLoader
extends AbstractExtensibleTypeLoader<ComponentConsumer> {
    private static final QName CONSUMER = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "consumer");
    private static final Map<String, String> ATTRIBUTES = new HashMap<String, String>();

    public ComponentConsumerLoader(@Reference LoaderRegistry registry) {
        super(registry);
    }

    @Override
    public QName getXMLType() {
        return CONSUMER;
    }

    public ComponentConsumer load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingProducerName failure = new MissingProducerName(reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        String targetAttribute = reader.getAttributeValue(null, "source");
        ArrayList<URI> targets = new ArrayList<URI>();
        try {
            if (targetAttribute != null) {
                StringTokenizer tokenizer = new StringTokenizer(targetAttribute);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    URI target = new URI(token);
                    targets.add(target);
                }
            }
        }
        catch (URISyntaxException e) {
            InvalidValue failure = new InvalidValue("Invalid source format", reader, (Throwable)e);
            context.addError((ValidationFailure)failure);
        }
        ComponentConsumer consumer = new ComponentConsumer(name, targets);
        while (true) {
            switch (reader.next()) {
                case 1: {
                    ModelObject type;
                    QName elementName = reader.getName();
                    try {
                        type = (ModelObject)this.registry.load(reader, ModelObject.class, context);
                    }
                    catch (UnrecognizedElementException e) {
                        UnrecognizedElement failure = new UnrecognizedElement(reader);
                        context.addError((ValidationFailure)failure);
                        break;
                    }
                    if (type instanceof BindingDefinition) {
                        BindingDefinition binding = (BindingDefinition)type;
                        boolean check = BindingHelper.checkDuplicateNames(binding, consumer.getBindings(), reader, context);
                        if (check) {
                            consumer.addBinding(binding);
                        }
                    } else {
                        if (type == null) break;
                        context.addError((ValidationFailure)new UnrecognizedElement(reader));
                        break;
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (!CONSUMER.equals(reader.getName())) break;
                    return consumer;
                }
            }
        }
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if (ATTRIBUTES.containsKey(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }

    static {
        ATTRIBUTES.put("name", "name");
        ATTRIBUTES.put("source", "source");
    }
}

