/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.introspection.xml.common.InvalidBinding;
import org.fabric3.introspection.xml.common.MissingReferenceName;
import org.fabric3.model.type.ModelObject;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.Autowire;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.ComponentReference;
import org.fabric3.model.type.component.Multiplicity;
import org.fabric3.model.type.component.Target;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidTargetException;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentReferenceLoader
extends AbstractExtensibleTypeLoader<ComponentReference> {
    private static final QName REFERENCE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "reference");
    private static final QName CALLBACK = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");
    private static final Map<String, String> ATTRIBUTES = new HashMap<String, String>();
    private LoaderHelper loaderHelper;

    public ComponentReferenceLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper loaderHelper) {
        super(registry);
        this.loaderHelper = loaderHelper;
    }

    @Override
    public QName getXMLType() {
        return REFERENCE;
    }

    /*
     * Unable to fully structure code
     */
    public ComponentReference load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        name = reader.getAttributeValue(null, "name");
        if (name == null) {
            failure = new MissingReferenceName(reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        autowire = reader.getAttributeValue(null, "autowire");
        value = reader.getAttributeValue(null, "multiplicity");
        multiplicity = null;
        try {
            if (value != null) {
                multiplicity = Multiplicity.fromString((String)value);
            }
        }
        catch (IllegalArgumentException e) {
            failure = new InvalidValue("Invalid multiplicity value: " + value, reader);
            context.addError((ValidationFailure)failure);
        }
        reference = new ComponentReference(name, multiplicity);
        if ("true".equalsIgnoreCase(autowire)) {
            reference.setAutowire(Autowire.ON);
        } else if ("false".equalsIgnoreCase(autowire)) {
            reference.setAutowire(Autowire.OFF);
        }
        targetAttribute = reader.getAttributeValue(null, "target");
        targets = new ArrayList<Target>();
        try {
            if (targetAttribute != null) {
                tokenizer = new StringTokenizer(targetAttribute);
                while (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    target = this.loaderHelper.parseTarget(token, reader);
                    targets.add(target);
                }
            }
        }
        catch (InvalidTargetException e) {
            failure = new InvalidValue("Invalid target format", reader, (Throwable)e);
            context.addError((ValidationFailure)failure);
        }
        reference.addTargets(targets);
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)reference, reader, context);
        callback = false;
        bindingError = false;
        while (true) {
            switch (reader.next()) {
                case 1: {
                    callback = ComponentReferenceLoader.CALLBACK.equals(reader.getName());
                    if (callback) {
                        reader.nextTag();
                    }
                    elementName = reader.getName();
                    try {
                        type = (ModelObject)this.registry.load(reader, ModelObject.class, context);
                    }
                    catch (UnrecognizedElementException e) {
                        failure = new UnrecognizedElement(reader);
                        context.addError((ValidationFailure)failure);
                        break;
                    }
                    if (!(type instanceof ServiceContract)) ** GOTO lbl60
                    reference.setServiceContract((ServiceContract)type);
                    ** GOTO lbl81
lbl60:
                    // 1 sources

                    if (!(type instanceof BindingDefinition)) ** GOTO lbl78
                    binding = (BindingDefinition)type;
                    if (!reference.getTargets().isEmpty()) {
                        if (bindingError) break;
                        error = new InvalidBinding("Bindings cannot be configured when the target attribute on a reference is used: " + name, reader);
                        context.addError((ValidationFailure)error);
                        bindingError = true;
                        break;
                    }
                    if (!callback) ** GOTO lbl73
                    if (binding.getName() == null) {
                        BindingHelper.configureName(binding, name, reference.getCallbackBindings(), reader, context);
                    }
                    reference.addCallbackBinding(binding);
                    ** GOTO lbl81
lbl73:
                    // 1 sources

                    if (binding.getName() == null) {
                        BindingHelper.configureName(binding, name, reference.getBindings(), reader, context);
                    }
                    if (!(check = BindingHelper.checkDuplicateNames(binding, reference.getBindings(), reader, context))) ** GOTO lbl81
                    reference.addBinding(binding);
                    ** GOTO lbl81
lbl78:
                    // 1 sources

                    if (type == null) break;
                    context.addError((ValidationFailure)new UnrecognizedElement(reader));
                    break;
lbl81:
                    // 4 sources

                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (callback) {
                        callback = false;
                        break;
                    }
                    return reference;
                }
            }
        }
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if (ATTRIBUTES.containsKey(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }

    static {
        ATTRIBUTES.put("name", "name");
        ATTRIBUTES.put("autowire", "autowire");
        ATTRIBUTES.put("target", "target");
        ATTRIBUTES.put("multiplicity", "multiplicity");
        ATTRIBUTES.put("requires", "requires");
        ATTRIBUTES.put("policySets", "policySets");
    }
}

