/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.common;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.model.type.ModelObject;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.ComponentService;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentServiceLoader
extends AbstractExtensibleTypeLoader<ComponentService> {
    private static final QName SERVICE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "service");
    private static final QName CALLBACK = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");
    private final LoaderHelper loaderHelper;

    public ComponentServiceLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper loaderHelper) {
        super(registry);
        this.loaderHelper = loaderHelper;
    }

    @Override
    public QName getXMLType() {
        return SERVICE;
    }

    public ComponentService load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute failure = new MissingAttribute("Missing name attribute", reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        ComponentService definition = new ComponentService(name);
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)definition, reader, context);
        boolean callback = false;
        while (true) {
            int i = reader.next();
            switch (i) {
                case 1: {
                    ModelObject type;
                    callback = CALLBACK.equals(reader.getName());
                    if (callback) {
                        reader.nextTag();
                    }
                    QName elementName = reader.getName();
                    try {
                        type = (ModelObject)this.registry.load(reader, ModelObject.class, context);
                    }
                    catch (UnrecognizedElementException e) {
                        UnrecognizedElement failure = new UnrecognizedElement(reader);
                        context.addError((ValidationFailure)failure);
                        break;
                    }
                    if (type instanceof ServiceContract) {
                        definition.setServiceContract((ServiceContract)type);
                    } else {
                        boolean check;
                        if (!(type instanceof BindingDefinition)) {
                            if (type == null) break;
                            context.addError((ValidationFailure)new UnrecognizedElement(reader));
                            break;
                        }
                        BindingDefinition binding = (BindingDefinition)type;
                        if (callback) {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, name, definition.getCallbackBindings(), reader, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, definition.getCallbackBindings(), reader, context)) {
                                definition.addCallbackBinding(binding);
                            }
                        } else {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, name, definition.getBindings(), reader, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, definition.getBindings(), reader, context)) {
                                definition.addBinding(binding);
                            }
                        }
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (callback) {
                        callback = false;
                        break;
                    }
                    return definition;
                }
            }
        }
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("name".equals(name) || "requires".equals(name) || "policySets".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }
}

