/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.common;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.common.InvalidAttributes;
import org.fabric3.introspection.xml.common.InvalidPropertyValue;
import org.fabric3.model.type.component.Property;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidPrefixException;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.osoa.sca.annotations.Reference;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyLoader
implements TypeLoader<Property> {
    private static final String NAME = "name";
    private static final String MANY = "many";
    private static final String MUST_SUPPLY = "mustSupply";
    private static final String TYPE = "type";
    private static final String ELEMENT = "element";
    private static final String SOURCE = "source";
    private static final String VALUE = "value";
    private final LoaderHelper helper;

    public PropertyLoader(@Reference LoaderHelper helper) {
        this.helper = helper;
    }

    public Property load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        InvalidAttributes error;
        this.validateAttributes(reader, context);
        String name = reader.getAttributeValue(null, NAME);
        boolean many = Boolean.parseBoolean(reader.getAttributeValue(null, MANY));
        boolean mustSupply = Boolean.parseBoolean(reader.getAttributeValue(null, MUST_SUPPLY));
        String typeAttribute = reader.getAttributeValue(null, TYPE);
        String elementAttribute = reader.getAttributeValue(null, ELEMENT);
        if (typeAttribute != null && elementAttribute != null) {
            InvalidAttributes error2 = new InvalidAttributes("Cannot specify both type and element attributes for a property", reader);
            context.addError((ValidationFailure)error2);
        }
        QName type = null;
        QName element = null;
        if (typeAttribute != null) {
            try {
                type = this.helper.createQName(typeAttribute, reader);
            }
            catch (InvalidPrefixException e) {
                error = new InvalidAttributes("Invalid property type namespace:" + e.getMessage(), reader);
                context.addError((ValidationFailure)error);
            }
        } else if (elementAttribute != null) {
            try {
                element = this.helper.createQName(elementAttribute, reader);
            }
            catch (InvalidPrefixException e) {
                error = new InvalidAttributes("Invalid property element namespace:" + e.getMessage(), reader);
                context.addError((ValidationFailure)error);
            }
        }
        String valueAttribute = reader.getAttributeValue(null, VALUE);
        Document value = this.helper.loadPropertyValues(reader);
        if (valueAttribute != null && value.getDocumentElement().getChildNodes().getLength() > 0) {
            InvalidPropertyValue error3 = new InvalidPropertyValue("Property value configured using the value attribute and inline: " + name, reader);
            context.addError((ValidationFailure)error3);
        }
        Property property = new Property(name);
        property.setRequired(mustSupply);
        property.setType(type);
        property.setElement(element);
        property.setMany(many);
        if (!many && value.getDocumentElement().getChildNodes().getLength() > 1) {
            InvalidPropertyValue error4 = new InvalidPropertyValue("A single-valued property is configured with multiple values: " + name, reader);
            context.addError((ValidationFailure)error4);
        } else {
            if (valueAttribute != null) {
                value = this.helper.loadPropertyValue(valueAttribute, reader);
            }
            property.setDefaultValue(value);
        }
        return property;
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if (NAME.equals(name) || MANY.equals(name) || MUST_SUPPLY.equals(name) || TYPE.equals(name) || SOURCE.equals(name) || ELEMENT.equals(name) || VALUE.equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }
}

