/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.InvalidAttributes;
import org.fabric3.introspection.xml.common.InvalidPropertyValue;
import org.fabric3.introspection.xml.composite.ComponentConsumerNotFound;
import org.fabric3.introspection.xml.composite.ComponentProducerNotFound;
import org.fabric3.introspection.xml.composite.ComponentPropertyNotFound;
import org.fabric3.introspection.xml.composite.ComponentReferenceNotFound;
import org.fabric3.introspection.xml.composite.ComponentServiceNotFound;
import org.fabric3.introspection.xml.composite.DuplicateComponentReference;
import org.fabric3.introspection.xml.composite.DuplicateComponentService;
import org.fabric3.introspection.xml.composite.DuplicateConfiguredProperty;
import org.fabric3.introspection.xml.composite.InvalidPropertyConfiguration;
import org.fabric3.introspection.xml.composite.MissingComponentImplementation;
import org.fabric3.introspection.xml.composite.RequiredPropertyNotProvided;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.Autowire;
import org.fabric3.model.type.component.ComponentConsumer;
import org.fabric3.model.type.component.ComponentDefinition;
import org.fabric3.model.type.component.ComponentProducer;
import org.fabric3.model.type.component.ComponentReference;
import org.fabric3.model.type.component.ComponentService;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.model.type.component.ConsumerDefinition;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.component.Multiplicity;
import org.fabric3.model.type.component.ProducerDefinition;
import org.fabric3.model.type.component.Property;
import org.fabric3.model.type.component.PropertyMany;
import org.fabric3.model.type.component.PropertyValue;
import org.fabric3.model.type.component.ReferenceDefinition;
import org.fabric3.model.type.component.ServiceDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.IncompatibleContracts;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.osoa.sca.annotations.Constructor;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ComponentLoader
extends AbstractExtensibleTypeLoader<ComponentDefinition<?>> {
    private static final QName COMPONENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "component");
    private static final QName PROPERTY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "property");
    private static final QName SERVICE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "service");
    private static final QName REFERENCE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "reference");
    private static final QName PRODUCER = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "producer");
    private static final QName CONSUMER = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "consumer");
    private static final Map<String, String> ATTRIBUTES = new HashMap<String, String>();
    private LoaderHelper loaderHelper;
    private ContractMatcher contractMatcher;

    public ComponentLoader(LoaderRegistry registry, LoaderHelper loaderHelper) {
        super(registry);
        this.loaderHelper = loaderHelper;
    }

    @Constructor
    public ComponentLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper loaderHelper, @Reference ContractMatcher contractMatcher) {
        super(registry);
        this.loaderHelper = loaderHelper;
        this.contractMatcher = contractMatcher;
    }

    public ComponentDefinition<?> load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute failure = new MissingAttribute("Component name not specified", reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        ComponentDefinition definition = new ComponentDefinition(name);
        definition.setContributionUri(context.getContributionUri());
        Autowire autowire = Autowire.fromString((String)reader.getAttributeValue(null, "autowire"));
        definition.setAutowire(autowire);
        String key = this.loaderHelper.loadKey(reader);
        definition.setKey(key);
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)definition, reader, context);
        try {
            reader.nextTag();
            QName elementName = reader.getName();
            if (COMPONENT.equals(elementName)) {
                MissingComponentImplementation error = new MissingComponentImplementation("The component " + name + " must specify an implementation", reader);
                context.addError((ValidationFailure)error);
                return definition;
            }
            if (PROPERTY.equals(elementName) || REFERENCE.equals(elementName) || SERVICE.equals(elementName) || PRODUCER.equals(elementName)) {
                MissingComponentImplementation error = new MissingComponentImplementation("The component " + name + " must specify an implementation as the first child element", reader);
                context.addError((ValidationFailure)error);
                return definition;
            }
            Implementation impl = (Implementation)this.registry.load(reader, Implementation.class, context);
            if (impl == null || impl.getComponentType() == null) {
                return definition;
            }
            if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                throw new AssertionError((Object)"Impementation loader must position the cursor to the end element");
            }
            definition.setImplementation(impl);
            ComponentType componentType = impl.getComponentType();
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        QName qname = reader.getName();
                        if (PROPERTY.equals(qname)) {
                            this.parsePropertyValue(definition, componentType, reader, context);
                            break;
                        }
                        if (REFERENCE.equals(qname)) {
                            this.parseReference(definition, componentType, reader, context);
                            break;
                        }
                        if (SERVICE.equals(qname)) {
                            this.parseService(definition, componentType, reader, context);
                            break;
                        }
                        if (PRODUCER.equals(qname)) {
                            this.parseProducer(definition, componentType, reader, context);
                            break;
                        }
                        if (CONSUMER.equals(qname)) {
                            this.parseConsumer(definition, componentType, reader, context);
                            break;
                        }
                        context.addError((ValidationFailure)new UnrecognizedElement(reader));
                        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
                        break;
                    }
                    case 2: {
                        assert (COMPONENT.equals(reader.getName()));
                        this.validateRequiredProperties(definition, reader, context);
                        return definition;
                    }
                }
            }
        }
        catch (UnrecognizedElementException e) {
            UnrecognizedElement failure = new UnrecognizedElement(reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
    }

    @Override
    public QName getXMLType() {
        return COMPONENT;
    }

    private void parseService(ComponentDefinition<?> definition, ComponentType componentType, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException, UnrecognizedElementException {
        ComponentService service = (ComponentService)this.registry.load(reader, ComponentService.class, context);
        if (service == null) {
            return;
        }
        String name = service.getName();
        ServiceDefinition typeService = (ServiceDefinition)componentType.getServices().get(name);
        if (typeService == null) {
            ComponentServiceNotFound failure = new ComponentServiceNotFound(name, definition, reader);
            context.addError((ValidationFailure)failure);
            return;
        }
        this.processServiceContract(service, typeService, reader, context);
        if (definition.getServices().containsKey(name)) {
            DuplicateComponentService failure = new DuplicateComponentService(name, definition.getName(), reader);
            context.addError((ValidationFailure)failure);
        } else {
            definition.add(service);
        }
    }

    private void parseReference(ComponentDefinition<?> definition, ComponentType componentType, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException, UnrecognizedElementException {
        ComponentReference reference = (ComponentReference)this.registry.load(reader, ComponentReference.class, context);
        if (reference == null) {
            return;
        }
        String name = reference.getName();
        ReferenceDefinition typeReference = (ReferenceDefinition)componentType.getReferences().get(name);
        if (typeReference == null) {
            ComponentReferenceNotFound failure = new ComponentReferenceNotFound(name, definition, reader);
            context.addError((ValidationFailure)failure);
            return;
        }
        this.processReferenceContract(reference, typeReference, reader, context);
        if (definition.getReferences().containsKey(name)) {
            DuplicateComponentReference failure = new DuplicateComponentReference(name, definition.getName(), reader);
            context.addError((ValidationFailure)failure);
            return;
        }
        this.processMultiplicity(reference, typeReference, reader, context);
        definition.add(reference);
    }

    private void parseProducer(ComponentDefinition<Implementation<?>> definition, ComponentType componentType, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException, UnrecognizedElementException {
        ComponentProducer producer = (ComponentProducer)this.registry.load(reader, ComponentProducer.class, context);
        if (producer == null) {
            return;
        }
        String name = producer.getName();
        ProducerDefinition typeProducer = (ProducerDefinition)componentType.getProducers().get(name);
        if (typeProducer == null) {
            ComponentProducerNotFound failure = new ComponentProducerNotFound(name, definition, reader);
            context.addError((ValidationFailure)failure);
            return;
        }
        definition.add(producer);
    }

    private void parseConsumer(ComponentDefinition<Implementation<?>> definition, ComponentType componentType, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException, UnrecognizedElementException {
        ComponentConsumer consumer = (ComponentConsumer)this.registry.load(reader, ComponentConsumer.class, context);
        if (consumer == null) {
            return;
        }
        String name = consumer.getName();
        ConsumerDefinition typeConsumer = (ConsumerDefinition)componentType.getConsumers().get(name);
        if (typeConsumer == null) {
            ComponentConsumerNotFound failure = new ComponentConsumerNotFound(name, definition, reader);
            context.addError((ValidationFailure)failure);
            return;
        }
        consumer.setTypes(typeConsumer.getTypes());
        definition.add(consumer);
    }

    private void parsePropertyValue(ComponentDefinition<?> definition, ComponentType componentType, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException, UnrecognizedElementException {
        PropertyValue value = (PropertyValue)this.registry.load(reader, PropertyValue.class, context);
        if (value == null) {
            return;
        }
        String name = value.getName();
        Property property = (Property)componentType.getProperties().get(name);
        if (property == null) {
            ComponentPropertyNotFound failure = new ComponentPropertyNotFound(value.getName(), definition, reader);
            context.addError((ValidationFailure)failure);
            return;
        }
        this.validatePropertyType(value, property, reader, context);
        if (definition.getPropertyValues().containsKey(value.getName())) {
            String id = value.getName();
            DuplicateConfiguredProperty failure = new DuplicateConfiguredProperty(id, definition, reader);
            context.addError((ValidationFailure)failure);
        } else {
            definition.add(value);
        }
    }

    private void processServiceContract(ComponentService service, ServiceDefinition typeService, XMLStreamReader reader, IntrospectionContext context) {
        if (service.getServiceContract() == null) {
            service.setServiceContract(typeService.getServiceContract());
        } else if (this.contractMatcher != null) {
            MatchResult result = this.contractMatcher.isAssignableFrom(service.getServiceContract(), typeService.getServiceContract(), true);
            if (!result.isAssignable()) {
                String name = service.getName();
                IncompatibleContracts error = new IncompatibleContracts("The component service interface " + name + " is not compatible with the promoted service " + typeService.getName() + ": " + result.getError(), reader);
                context.addError((ValidationFailure)error);
            } else {
                this.matchServiceCallbackContracts(service, typeService, reader, context);
            }
        }
    }

    private void processReferenceContract(ComponentReference reference, ReferenceDefinition typeReference, XMLStreamReader reader, IntrospectionContext context) {
        if (reference.getServiceContract() == null) {
            reference.setServiceContract(typeReference.getServiceContract());
        } else if (this.contractMatcher != null) {
            MatchResult result = this.contractMatcher.isAssignableFrom(typeReference.getServiceContract(), reference.getServiceContract(), true);
            if (!result.isAssignable()) {
                String name = reference.getName();
                IncompatibleContracts error = new IncompatibleContracts("The component reference contract " + name + " is not compatible with the promoted reference " + typeReference.getName() + ": " + result.getError(), reader);
                context.addError((ValidationFailure)error);
            } else {
                this.matchReferenceCallbackContracts(reference, typeReference, reader, context);
            }
        }
    }

    private void matchServiceCallbackContracts(ComponentService service, ServiceDefinition typeService, XMLStreamReader reader, IntrospectionContext context) {
        ServiceContract callbackContract = service.getServiceContract().getCallbackContract();
        if (callbackContract == null) {
            return;
        }
        ServiceContract typeCallbackContract = typeService.getServiceContract().getCallbackContract();
        if (typeCallbackContract == null) {
            IncompatibleContracts error = new IncompatibleContracts("Component type for service " + service.getName() + " does not have a callback contract", reader);
            context.addError((ValidationFailure)error);
            return;
        }
        MatchResult result = this.contractMatcher.isAssignableFrom(typeCallbackContract, callbackContract, true);
        if (!result.isAssignable()) {
            String name = service.getName();
            IncompatibleContracts error = new IncompatibleContracts("The component service " + name + " callback contract is not compatible with " + "the promoted service " + typeService.getName() + " callback contract: " + result.getError(), reader);
            context.addError((ValidationFailure)error);
        }
    }

    private void matchReferenceCallbackContracts(ComponentReference reference, ReferenceDefinition typeReference, XMLStreamReader reader, IntrospectionContext context) {
        ServiceContract callbackContract = reference.getServiceContract().getCallbackContract();
        if (callbackContract == null) {
            return;
        }
        ServiceContract typeCallbackContract = typeReference.getServiceContract().getCallbackContract();
        if (typeCallbackContract == null) {
            IncompatibleContracts error = new IncompatibleContracts("Component type for reference " + reference.getName() + " does not have a callback contract", reader);
            context.addError((ValidationFailure)error);
            return;
        }
        MatchResult result = this.contractMatcher.isAssignableFrom(typeCallbackContract, callbackContract, true);
        if (!result.isAssignable()) {
            String name = reference.getName();
            IncompatibleContracts error = new IncompatibleContracts("The component reference " + name + " callback contract is not compatible with " + "the promoted reference " + typeReference.getName() + " callback contract: " + result.getError(), reader);
            context.addError((ValidationFailure)error);
        }
    }

    private void processMultiplicity(ComponentReference reference, ReferenceDefinition typeReference, XMLStreamReader reader, IntrospectionContext context) {
        String name = reference.getName();
        if (reference.getMultiplicity() == null) {
            Multiplicity multiplicity = typeReference.getMultiplicity();
            reference.setMultiplicity(multiplicity);
        } else if (!this.loaderHelper.canNarrow(reference.getMultiplicity(), typeReference.getMultiplicity())) {
            InvalidValue failure = new InvalidValue("The multiplicity setting for reference " + name + " widens the default setting", reader);
            context.addError((ValidationFailure)failure);
        }
        List targets = reference.getTargets();
        Multiplicity multiplicity = reference.getMultiplicity();
        if (targets.size() > 1 && (Multiplicity.ZERO_ONE == multiplicity || Multiplicity.ONE_ONE == multiplicity)) {
            InvalidValue failure = new InvalidValue("Multiple targets configured on reference " + name + ", which takes a single target", reader);
            context.addError((ValidationFailure)failure);
        }
    }

    private void validateRequiredProperties(ComponentDefinition<?> definition, XMLStreamReader reader, IntrospectionContext context) {
        ComponentType type = definition.getImplementation().getComponentType();
        Map properties = type.getProperties();
        Map values = definition.getPropertyValues();
        for (Property property : properties.values()) {
            PropertyValue value = (PropertyValue)values.get(property.getName());
            if (property.isRequired() && value == null) {
                RequiredPropertyNotProvided failure = new RequiredPropertyNotProvided(property, definition.getName(), reader);
                context.addError((ValidationFailure)failure);
                continue;
            }
            if (value == null) continue;
            this.validateAndSetMany(value, property, reader, context);
        }
    }

    private void validateAndSetMany(PropertyValue propertyValue, Property property, XMLStreamReader reader, IntrospectionContext context) {
        PropertyMany propertyMany = propertyValue.getMany();
        if (PropertyMany.NOT_SPECIFIED == propertyMany) {
            if (property.isMany()) {
                propertyValue.setMany(PropertyMany.MANY);
            } else {
                propertyValue.setMany(PropertyMany.SINGLE);
            }
        } else if (PropertyMany.MANY == propertyMany) {
            if (!property.isMany()) {
                InvalidPropertyConfiguration error = new InvalidPropertyConfiguration("Illegal attempt to make a property many-valued when its component type is single-valued", reader);
                context.addError((ValidationFailure)error);
                return;
            }
            propertyValue.setMany(PropertyMany.MANY);
        } else {
            propertyValue.setMany(PropertyMany.SINGLE);
        }
        Document value = propertyValue.getValue();
        if (value != null && PropertyMany.MANY != propertyValue.getMany() && value.getDocumentElement().getChildNodes().getLength() > 1) {
            String name = propertyValue.getName();
            InvalidPropertyValue error = new InvalidPropertyValue("A single-valued property is configured with multiple values: " + name, reader);
            context.addError((ValidationFailure)error);
        }
    }

    private void validatePropertyType(PropertyValue value, Property property, XMLStreamReader reader, IntrospectionContext context) {
        QName propType = property.getType();
        QName propElement = property.getElement();
        QName valType = value.getType();
        QName valElement = value.getElement();
        if (propType != null) {
            if (valElement != null) {
                InvalidAttributes error = new InvalidAttributes("Cannot specify property schema type and element type on property configuration: " + value.getName(), reader);
                context.addError((ValidationFailure)error);
            } else if (valType != null && !valType.equals(propType)) {
                InvalidAttributes error = new InvalidAttributes("Property type " + propType + " and property configuration type " + valType + " do not match: " + value.getName(), reader);
                context.addError((ValidationFailure)error);
            }
        } else if (propElement != null) {
            if (valType != null) {
                InvalidAttributes error = new InvalidAttributes("Cannot specify property element type and property configuration schema type: " + value.getName(), reader);
                context.addError((ValidationFailure)error);
            } else if (valElement != null && !valElement.equals(propElement)) {
                InvalidAttributes error = new InvalidAttributes("Property element type " + propElement + " and property configuration element type " + valElement + " do not match: " + value.getName(), reader);
                context.addError((ValidationFailure)error);
            }
        }
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if (ATTRIBUTES.containsKey(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }

    static {
        ATTRIBUTES.put("name", "name");
        ATTRIBUTES.put("autowire", "autowire");
        ATTRIBUTES.put("requires", "requires");
        ATTRIBUTES.put("policySets", "policySets");
        ATTRIBUTES.put("key", "key");
    }
}

