/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.introspection.xml.composite.MissingPromotion;
import org.fabric3.model.type.ModelObject;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.CompositeReference;
import org.fabric3.model.type.component.Multiplicity;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeReferenceLoader
implements TypeLoader<CompositeReference> {
    private static final QName CALLBACK = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");
    private static final Map<String, String> ATTRIBUTES = new HashMap<String, String>();
    private LoaderRegistry registry;
    private LoaderHelper loaderHelper;

    public CompositeReferenceLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper loaderHelper) {
        this.registry = registry;
        this.loaderHelper = loaderHelper;
    }

    public CompositeReference load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        List promotedUris;
        this.validateAttributes(reader, context);
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute failure = new MissingAttribute("Reference name not specified", reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        boolean promoteError = false;
        try {
            promotedUris = this.loaderHelper.parseListOfUris(reader, "promote");
        }
        catch (URISyntaxException e) {
            InvalidValue error = new InvalidValue("Invalid promote URI specified on reference: " + name, reader, (Throwable)e);
            context.addError((ValidationFailure)error);
            promotedUris = Collections.emptyList();
            promoteError = true;
        }
        if (!promoteError && (promotedUris == null || promotedUris.isEmpty())) {
            MissingPromotion error = new MissingPromotion("Promotion not specified on composite reference " + name, reader);
            context.addError((ValidationFailure)error);
        }
        Multiplicity multiplicity = null;
        String value = reader.getAttributeValue(null, "multiplicity");
        try {
            if (value != null) {
                multiplicity = Multiplicity.fromString((String)value);
            }
        }
        catch (IllegalArgumentException e) {
            InvalidValue failure = new InvalidValue("Invalid multiplicity value: " + value, reader);
            context.addError((ValidationFailure)failure);
        }
        CompositeReference referenceDefinition = new CompositeReference(name, promotedUris, multiplicity);
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)referenceDefinition, reader, context);
        boolean callback = false;
        while (true) {
            switch (reader.next()) {
                case 1: {
                    ModelObject type;
                    callback = CALLBACK.equals(reader.getName());
                    if (callback) {
                        reader.nextTag();
                    }
                    QName elementName = reader.getName();
                    try {
                        type = (ModelObject)this.registry.load(reader, ModelObject.class, context);
                    }
                    catch (UnrecognizedElementException e) {
                        UnrecognizedElement failure = new UnrecognizedElement(reader);
                        context.addError((ValidationFailure)failure);
                        break;
                    }
                    if (type instanceof ServiceContract) {
                        referenceDefinition.setServiceContract((ServiceContract)type);
                    } else {
                        boolean check;
                        if (!(type instanceof BindingDefinition)) {
                            if (type == null) break;
                            context.addError((ValidationFailure)new UnrecognizedElement(reader));
                            break;
                        }
                        BindingDefinition binding = (BindingDefinition)type;
                        if (callback) {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, name, referenceDefinition.getCallbackBindings(), reader, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, referenceDefinition.getCallbackBindings(), reader, context)) {
                                referenceDefinition.addCallbackBinding(binding);
                            }
                        } else {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, name, referenceDefinition.getBindings(), reader, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, referenceDefinition.getBindings(), reader, context)) {
                                referenceDefinition.addBinding(binding);
                            }
                        }
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (callback) {
                        callback = false;
                        break;
                    }
                    return referenceDefinition;
                }
            }
        }
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if (ATTRIBUTES.containsKey(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }

    static {
        ATTRIBUTES.put("name", "name");
        ATTRIBUTES.put("autowire", "autowire");
        ATTRIBUTES.put("promote", "promote");
        ATTRIBUTES.put("multiplicity", "multiplicity");
        ATTRIBUTES.put("requires", "requires");
        ATTRIBUTES.put("policySets", "policySets");
    }
}

