/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.introspection.xml.composite.MissingPromotion;
import org.fabric3.model.type.ModelObject;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.CompositeService;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeServiceLoader
implements TypeLoader<CompositeService> {
    private static final QName CALLBACK = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");
    private LoaderRegistry registry;
    private LoaderHelper loaderHelper;

    public CompositeServiceLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper loaderHelper) {
        this.registry = registry;
        this.loaderHelper = loaderHelper;
    }

    public CompositeService load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        URI uri;
        this.validateAttributes(reader, context);
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute failure = new MissingAttribute("Service name not specified", reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        String promote = reader.getAttributeValue(null, "promote");
        if (promote == null) {
            MissingPromotion error = new MissingPromotion("Promotion not specified on composite service " + name, reader);
            context.addError((ValidationFailure)error);
        }
        try {
            uri = this.loaderHelper.parseUri(promote);
        }
        catch (URISyntaxException e) {
            InvalidValue error = new InvalidValue("Invalid promote URI specified on service " + name, reader, (Throwable)e);
            context.addError((ValidationFailure)error);
            uri = URI.create("");
        }
        CompositeService def = new CompositeService(name, null, uri);
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)def, reader, context);
        boolean callback = false;
        while (true) {
            int i = reader.next();
            switch (i) {
                case 1: {
                    ModelObject type;
                    callback = CALLBACK.equals(reader.getName());
                    if (callback) {
                        reader.nextTag();
                    }
                    QName elementName = reader.getName();
                    try {
                        type = (ModelObject)this.registry.load(reader, ModelObject.class, context);
                    }
                    catch (UnrecognizedElementException e) {
                        UnrecognizedElement failure = new UnrecognizedElement(reader);
                        context.addError((ValidationFailure)failure);
                        break;
                    }
                    if (type instanceof ServiceContract) {
                        def.setServiceContract((ServiceContract)type);
                    } else {
                        boolean check;
                        if (!(type instanceof BindingDefinition)) {
                            if (type == null) break;
                            context.addError((ValidationFailure)new UnrecognizedElement(reader));
                            break;
                        }
                        BindingDefinition binding = (BindingDefinition)type;
                        if (callback) {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, name, def.getCallbackBindings(), reader, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, def.getCallbackBindings(), reader, context)) {
                                def.addCallbackBinding(binding);
                            }
                        } else {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, name, def.getBindings(), reader, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, def.getBindings(), reader, context)) {
                                def.addBinding(binding);
                            }
                        }
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (callback) {
                        callback = false;
                        break;
                    }
                    return def;
                }
            }
        }
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("name".equals(name) || "requires".equals(name) || "promote".equals(name) || "policySets".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }
}

