/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.StoreException;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.host.stream.Source;
import org.fabric3.host.stream.UrlSource;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.composite.MissingComposite;
import org.fabric3.model.type.component.Composite;
import org.fabric3.model.type.component.Include;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.ElementLoadFailure;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderException;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.osoa.sca.annotations.Constructor;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeLoader
extends AbstractExtensibleTypeLoader<Include> {
    private static final QName INCLUDE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "include");
    private static final Map<String, String> ATTRIBUTES = new HashMap<String, String>();
    private MetaDataStore store;

    public IncludeLoader(LoaderRegistry registry) {
        super(registry);
    }

    @Constructor
    public IncludeLoader(@Reference LoaderRegistry registry, @Reference(required=false) MetaDataStore store) {
        super(registry);
        this.store = store;
    }

    @Override
    public QName getXMLType() {
        return INCLUDE;
    }

    public Include load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String nameAttr = reader.getAttributeValue(null, "name");
        if (nameAttr == null || nameAttr.length() == 0) {
            MissingAttribute failure = new MissingAttribute("Missing name attribute", reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        QName name = LoaderUtil.getQName((String)nameAttr, (String)context.getTargetNamespace(), (NamespaceContext)reader.getNamespaceContext());
        String scdlResource = reader.getAttributeValue(null, "scdlResource");
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        ClassLoader cl = context.getClassLoader();
        URI contributionUri = context.getContributionUri();
        if (scdlResource != null) {
            URL url = cl.getResource(scdlResource);
            if (url == null) {
                MissingComposite failure = new MissingComposite("Composite file not found: " + scdlResource, reader);
                context.addError((ValidationFailure)failure);
                return null;
            }
            return this.loadFromSideFile(name, cl, contributionUri, url, reader, context);
        }
        if (this.store == null) {
            throw new UnsupportedOperationException("scdlLocation or scdlResource must be supplied as no MetaDataStore is available");
        }
        try {
            QNameSymbol symbol = new QNameSymbol(name);
            ResourceElement element = this.store.resolve(contributionUri, Composite.class, (Symbol)symbol, context);
            if (element == null) {
                String id = name.toString();
                MissingComposite failure = new MissingComposite("Composite file not found: " + id, reader);
                context.addError((ValidationFailure)failure);
                return null;
            }
            Composite composite = (Composite)element.getValue();
            Include include = new Include();
            include.setName(name);
            include.setIncluded(composite);
            return include;
        }
        catch (StoreException e) {
            ElementLoadFailure failure = new ElementLoadFailure("Error loading element", (Throwable)e, reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
    }

    private Include loadFromSideFile(QName name, ClassLoader cl, URI contributionUri, URL url, XMLStreamReader reader, IntrospectionContext context) {
        Composite composite;
        Include include = new Include();
        DefaultIntrospectionContext childContext = new DefaultIntrospectionContext(contributionUri, cl, url);
        try {
            UrlSource source = new UrlSource(url);
            composite = (Composite)this.registry.load((Source)source, Composite.class, (IntrospectionContext)childContext);
        }
        catch (LoaderException e) {
            InvalidValue failure = new InvalidValue("Error loading include", reader);
            context.addError((ValidationFailure)failure);
            return include;
        }
        if (childContext.hasErrors()) {
            context.addErrors(childContext.getErrors());
        }
        if (childContext.hasWarnings()) {
            context.addWarnings(childContext.getWarnings());
        }
        include.setName(name);
        include.setScdlLocation(url);
        include.setIncluded(composite);
        return include;
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if (ATTRIBUTES.containsKey(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }

    static {
        ATTRIBUTES.put("name", "name");
        ATTRIBUTES.put("scdlResource", "scdlResource");
        ATTRIBUTES.put("requires", "requires");
    }
}

