/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.InvalidAttributes;
import org.fabric3.introspection.xml.common.InvalidPropertyValue;
import org.fabric3.model.type.component.PropertyMany;
import org.fabric3.model.type.component.PropertyValue;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidPrefixException;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.introspection.xml.XmlValidationFailure;
import org.osoa.sca.annotations.Reference;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyValueLoader
extends AbstractExtensibleTypeLoader<PropertyValue> {
    private static final QName PROPERTY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "property");
    private static final Map<String, String> ATTRIBUTES = new HashMap<String, String>();
    private final LoaderHelper helper;

    public PropertyValueLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper helper) {
        super(registry);
        this.helper = helper;
    }

    @Override
    public QName getXMLType() {
        return PROPERTY;
    }

    public PropertyValue load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String name = reader.getAttributeValue(null, "name");
        if (name == null || name.length() == 0) {
            MissingAttribute failure = new MissingAttribute("Missing name attribute", reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        String source = reader.getAttributeValue(null, "source");
        String file = reader.getAttributeValue(null, "file");
        if (source != null) {
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return new PropertyValue(name, source);
        }
        if (file != null) {
            try {
                URI uri = new URI(file);
                if (!uri.isAbsolute()) {
                    uri = context.getSourceBase().toURI().resolve(uri);
                }
                LoaderUtil.skipToEndElement((XMLStreamReader)reader);
                return new PropertyValue(name, uri);
            }
            catch (URISyntaxException e) {
                InvalidValue failure = new InvalidValue("File specified for property " + name + " is invalid: " + file, reader, (Throwable)e);
                context.addError((ValidationFailure)failure);
                return null;
            }
        }
        return this.loadInlinePropertyValue(name, reader, context);
    }

    private PropertyValue loadInlinePropertyValue(String name, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        XmlValidationFailure error;
        String typeAttribute = reader.getAttributeValue(null, "type");
        String elementAttribute = reader.getAttributeValue(null, "element");
        PropertyMany many = this.parseMany(reader);
        String valueAttribute = reader.getAttributeValue(null, "value");
        QName type = null;
        QName element = null;
        if (typeAttribute != null) {
            if (elementAttribute != null) {
                InvalidValue failure = new InvalidValue("Cannot supply both type and element for property: " + name, reader);
                context.addError((ValidationFailure)failure);
            }
            try {
                type = this.helper.createQName(typeAttribute, reader);
            }
            catch (InvalidPrefixException e) {
                error = new InvalidAttributes("Invalid property type namespace:" + e.getMessage(), reader);
                context.addError((ValidationFailure)error);
            }
        } else if (elementAttribute != null) {
            try {
                element = this.helper.createQName(elementAttribute, reader);
            }
            catch (InvalidPrefixException e) {
                error = new InvalidAttributes("Invalid property element namespace:" + e.getMessage(), reader);
                context.addError((ValidationFailure)error);
            }
        }
        Document value = this.helper.loadPropertyValues(reader);
        if (valueAttribute != null && value.getDocumentElement().getChildNodes().getLength() > 0) {
            error = new InvalidPropertyValue("Property value configured using the value attribute and inline: " + name, reader);
            context.addError((ValidationFailure)error);
        }
        if (valueAttribute != null) {
            value = this.helper.loadPropertyValue(valueAttribute, reader);
        }
        PropertyValue propertyValue = new PropertyValue(name, value, many);
        propertyValue.setElement(element);
        propertyValue.setType(type);
        return propertyValue;
    }

    private PropertyMany parseMany(XMLStreamReader reader) {
        String manyAttribute = reader.getAttributeValue(null, "many");
        if (manyAttribute == null) {
            return PropertyMany.NOT_SPECIFIED;
        }
        if (manyAttribute.equalsIgnoreCase("true")) {
            return PropertyMany.MANY;
        }
        return PropertyMany.SINGLE;
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if (ATTRIBUTES.containsKey(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }

    static {
        ATTRIBUTES.put("name", "name");
        ATTRIBUTES.put("source", "source");
        ATTRIBUTES.put("file", "file");
        ATTRIBUTES.put("type", "type");
        ATTRIBUTES.put("element", "element");
        ATTRIBUTES.put("value", "value");
        ATTRIBUTES.put("many", "many");
    }
}

