/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class StatefulNamespaceContext
implements NamespaceContext {
    private Map<String, String> prefixToUri = new HashMap<String, String>();
    private Map<String, List<String>> uriToPrefixes = new HashMap<String, List<String>>();

    public String getNamespaceURI(String prefix) {
        return this.prefixToUri.get(prefix);
    }

    public String getPrefix(String namespaceURI) {
        List<String> list = this.uriToPrefixes.get(namespaceURI);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public Iterator getPrefixes(String namespaceURI) {
        List<String> list = this.uriToPrefixes.get(namespaceURI);
        if (list == null) {
            return Collections.emptyList().iterator();
        }
        return list.iterator();
    }

    public void addNamespace(String prefix, String namespaceURI) {
        this.prefixToUri.put(prefix, namespaceURI);
        List<String> list = this.uriToPrefixes.get(namespaceURI);
        if (list == null) {
            list = new ArrayList<String>();
            this.uriToPrefixes.put(namespaceURI, list);
        }
        list.add(prefix);
    }
}

