/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.model.type.component.Target;
import org.fabric3.model.type.component.WireDefinition;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidTargetException;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class WireLoader
implements TypeLoader<WireDefinition> {
    private LoaderHelper helper;

    public WireLoader(@Reference LoaderHelper helper) {
        this.helper = helper;
    }

    public WireDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String referenceAttribute = reader.getAttributeValue(null, "source");
        String serviceAttribute = reader.getAttributeValue(null, "target");
        boolean replace = Boolean.parseBoolean(reader.getAttributeValue(null, "replace"));
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        Target referenceTarget = null;
        Target serviceTarget = null;
        try {
            referenceTarget = this.helper.parseTarget(referenceAttribute, reader);
            serviceTarget = this.helper.parseTarget(serviceAttribute, reader);
        }
        catch (InvalidTargetException e) {
            InvalidValue failure = new InvalidValue("Invalid wire attribute", reader, (Throwable)e);
            context.addError((ValidationFailure)failure);
        }
        return new WireDefinition(referenceTarget, serviceTarget, replace);
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("source".equals(name) || "target".equals(name) || "requires".equals(name) || "replace".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }
}

