/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.definitions;

import java.net.URI;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.model.type.definitions.PolicyPhase;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidPrefixException;
import org.fabric3.spi.introspection.xml.InvalidQNamePrefix;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class PolicySetLoader
implements TypeLoader<PolicySet> {
    private final LoaderHelper helper;

    public PolicySetLoader(@Reference LoaderHelper helper) {
        this.helper = helper;
    }

    public PolicySet load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        Element policyElement = this.helper.transform(reader).getDocumentElement();
        String name = policyElement.getAttribute("name");
        QName qName = new QName(context.getTargetNamespace(), name);
        HashSet<QName> provides = new HashSet<QName>();
        StringTokenizer tok = new StringTokenizer(policyElement.getAttribute("provides"));
        while (tok.hasMoreElements()) {
            try {
                provides.add(this.helper.createQName(tok.nextToken(), reader));
            }
            catch (InvalidPrefixException e) {
                String prefix = e.getPrefix();
                URI uri = context.getContributionUri();
                context.addError((ValidationFailure)new InvalidQNamePrefix("The prefix " + prefix + " specified in the definitions.xml file in contribution " + uri + " is invalid", reader));
                return null;
            }
        }
        String appliesTo = policyElement.getAttribute("appliesTo");
        String attachTo = policyElement.getAttribute("attachTo");
        Node extension = null;
        NodeList children = policyElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            extension = (Element)children.item(i);
            break;
        }
        PolicyPhase phase = PolicyPhase.PROVIDED;
        if (extension != null && "urn:fabric3.org:policy".equals(extension.getNamespaceURI())) {
            String phaseAttr = extension.getAttributeNS("urn:fabric3.org:policy", "phase");
            if (phaseAttr != null && phaseAttr.length() > 0) {
                try {
                    phase = PolicyPhase.valueOf((String)phaseAttr.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    UnrecognizedAttribute failure = new UnrecognizedAttribute("Invalid phase: " + phaseAttr, reader);
                    context.addError((ValidationFailure)failure);
                    return null;
                }
            } else {
                phase = PolicyPhase.INTERCEPTION;
            }
        }
        URI uri = context.getContributionUri();
        return new PolicySet(qName, provides, appliesTo, attachTo, (Element)extension, phase, uri);
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("name".equals(name) || "provides".equals(name) || "appliesTo".equals(name) || "phase".equals(name) || "attachTo".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }
}

