/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.generator;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.binding.jms.generator.JmsGenerationException;
import org.fabric3.binding.jms.generator.PayloadTypeIntrospector;
import org.fabric3.binding.jms.model.JmsBindingDefinition;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.common.TransactionType;
import org.fabric3.binding.jms.spi.generator.JmsResourceProvisioner;
import org.fabric3.binding.jms.spi.provision.JmsSourceDefinition;
import org.fabric3.binding.jms.spi.provision.JmsTargetDefinition;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.provision.PayloadType;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.spi.generator.BindingGenerator;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.type.xsd.XSDType;
import org.fabric3.spi.policy.EffectivePolicy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JmsBindingGenerator
implements BindingGenerator<JmsBindingDefinition> {
    private static final QName TRANSACTED_ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "transactedOneWay");
    private static final QName IMMEDIATE_ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "immediateOneWay");
    private static final QName ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "oneWay");
    private static final DataType<?> ANY = new XSDType(String.class, new QName("http://www.w3.org/2001/XMLSchema", "anyType"));
    private PayloadTypeIntrospector introspector;
    private JmsResourceProvisioner provisioner;

    public JmsBindingGenerator(@Reference PayloadTypeIntrospector introspector) {
        this.introspector = introspector;
    }

    @Reference(required=false)
    public void setProvisioner(JmsResourceProvisioner provisioner) {
        this.provisioner = provisioner;
    }

    public JmsSourceDefinition generateSource(LogicalBinding<JmsBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        TransactionType transactionType = this.getTransactionType(operations, policy);
        JmsBindingMetadata metadata = ((JmsBindingDefinition)binding.getDefinition()).getJmsMetadata();
        this.validateResponseDestination(metadata, contract);
        List<OperationPayloadTypes> payloadTypes = this.processPayloadTypes(contract);
        URI uri = ((JmsBindingDefinition)binding.getDefinition()).getTargetUri();
        JmsSourceDefinition definition = null;
        for (OperationPayloadTypes types : payloadTypes) {
            if (PayloadType.XML != types.getInputType()) continue;
            definition = new JmsSourceDefinition(uri, metadata, payloadTypes, transactionType, ANY);
            break;
        }
        if (definition == null) {
            definition = new JmsSourceDefinition(uri, metadata, payloadTypes, transactionType);
        }
        if (this.provisioner != null) {
            this.provisioner.generateSource(definition);
        }
        return definition;
    }

    public JmsTargetDefinition generateTarget(LogicalBinding<JmsBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        TransactionType transactionType = this.getTransactionType(operations, policy);
        URI uri = ((JmsBindingDefinition)binding.getDefinition()).getTargetUri();
        JmsBindingMetadata metadata = ((JmsBindingDefinition)binding.getDefinition()).getJmsMetadata();
        this.validateResponseDestination(metadata, contract);
        List<OperationPayloadTypes> payloadTypes = this.processPayloadTypes(contract);
        JmsTargetDefinition definition = null;
        for (OperationPayloadTypes types : payloadTypes) {
            if (PayloadType.XML != types.getInputType()) continue;
            definition = new JmsTargetDefinition(uri, metadata, payloadTypes, transactionType, ANY);
            break;
        }
        if (definition == null) {
            definition = new JmsTargetDefinition(uri, metadata, payloadTypes, transactionType);
        }
        if (this.provisioner != null) {
            this.provisioner.generateTarget(definition);
        }
        return definition;
    }

    public JmsTargetDefinition generateServiceBindingTarget(LogicalBinding<JmsBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        return this.generateTarget((LogicalBinding)binding, contract, (List)operations, policy);
    }

    private void validateResponseDestination(JmsBindingMetadata metadata, ServiceContract contract) throws GenerationException {
        if (metadata.isResponse()) {
            return;
        }
        for (Operation operation : contract.getOperations()) {
            if (operation.getIntents().contains(ONEWAY)) continue;
            throw new GenerationException("Response destination must be specified for operation " + operation.getName() + " on " + contract.getInterfaceName());
        }
    }

    private TransactionType getTransactionType(List<LogicalOperation> operations, EffectivePolicy policy) {
        for (LogicalOperation operation : operations) {
            for (Intent intent : policy.getIntents(operation)) {
                QName name = intent.getName();
                if (TRANSACTED_ONEWAY.equals(name)) {
                    return TransactionType.GLOBAL;
                }
                if (!IMMEDIATE_ONEWAY.equals(name)) continue;
                return TransactionType.NONE;
            }
        }
        for (Intent intent : policy.getEndpointIntents()) {
            QName name = intent.getName();
            if (TRANSACTED_ONEWAY.equals(name)) {
                return TransactionType.GLOBAL;
            }
            if (!IMMEDIATE_ONEWAY.equals(name)) continue;
            return TransactionType.NONE;
        }
        return TransactionType.NONE;
    }

    private List<OperationPayloadTypes> processPayloadTypes(ServiceContract serviceContract) throws JmsGenerationException {
        ArrayList<OperationPayloadTypes> types = new ArrayList<OperationPayloadTypes>();
        for (Operation operation : serviceContract.getOperations()) {
            OperationPayloadTypes payloadType = this.introspector.introspect(operation);
            types.add(payloadType);
        }
        return types;
    }
}

