/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.generator;

import java.net.URI;
import org.fabric3.binding.jms.model.JmsBindingDefinition;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.generator.JmsResourceProvisioner;
import org.fabric3.binding.jms.spi.provision.JmsConnectionSourceDefinition;
import org.fabric3.binding.jms.spi.provision.JmsConnectionTargetDefinition;
import org.fabric3.spi.generator.ConnectionBindingGenerator;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JmsConnectionBindingGenerator
implements ConnectionBindingGenerator<JmsBindingDefinition> {
    private JmsResourceProvisioner provisioner;

    @Reference(required=false)
    public void setProvisioner(JmsResourceProvisioner provisioner) {
        this.provisioner = provisioner;
    }

    public PhysicalConnectionSourceDefinition generateConnectionSource(LogicalBinding<JmsBindingDefinition> binding) throws GenerationException {
        JmsBindingMetadata metadata = ((JmsBindingDefinition)binding.getDefinition()).getJmsMetadata();
        URI uri = ((JmsBindingDefinition)binding.getDefinition()).getTargetUri();
        JmsConnectionSourceDefinition definition = new JmsConnectionSourceDefinition(uri, metadata);
        if (this.provisioner != null) {
            this.provisioner.generateConnectionSource(definition);
        }
        return definition;
    }

    public PhysicalConnectionTargetDefinition generateConnectionTarget(LogicalBinding<JmsBindingDefinition> binding) throws GenerationException {
        URI uri = ((JmsBindingDefinition)binding.getDefinition()).getTargetUri();
        JmsBindingMetadata metadata = ((JmsBindingDefinition)binding.getDefinition()).getJmsMetadata();
        JmsConnectionTargetDefinition definition = new JmsConnectionTargetDefinition(uri, metadata);
        if (this.provisioner != null) {
            this.provisioner.generateConnectionTarget(definition);
        }
        return definition;
    }
}

