/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.generator;

import java.io.InputStream;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.fabric3.binding.jms.generator.JmsGenerationException;
import org.fabric3.binding.jms.generator.PayloadTypeIntrospector;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.provision.PayloadType;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.model.type.contract.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayloadTypeIntrospectorImpl
implements PayloadTypeIntrospector {
    @Override
    public OperationPayloadTypes introspect(Operation operation) throws JmsGenerationException {
        PayloadType inputType;
        List inputTypes = operation.getInputTypes();
        if (inputTypes.size() == 1) {
            DataType param = (DataType)inputTypes.get(0);
            inputType = this.introspectType(param);
        } else {
            inputType = PayloadType.OBJECT;
        }
        PayloadType outputType = this.introspectType(operation.getOutputType());
        if (outputType == PayloadType.XML) {
            return new OperationPayloadTypes(operation.getName(), inputType, outputType, PayloadType.XML);
        }
        return new OperationPayloadTypes(operation.getName(), inputType, outputType, PayloadType.OBJECT);
    }

    private PayloadType introspectType(DataType<?> param) throws JmsGenerationException {
        Class physical = param.getPhysical();
        if (physical.isPrimitive() && !Void.TYPE.equals(physical)) {
            return this.calculatePrimitivePayloadType(physical);
        }
        if (InputStream.class.isAssignableFrom(physical)) {
            return PayloadType.STREAM;
        }
        if (String.class.isAssignableFrom(physical)) {
            return PayloadType.TEXT;
        }
        if (physical.isAnnotationPresent(XmlRootElement.class) || physical.isAnnotationPresent(XmlType.class)) {
            return PayloadType.XML;
        }
        return PayloadType.OBJECT;
    }

    private PayloadType calculatePrimitivePayloadType(Class<?> clazz) throws JmsGenerationException {
        if (Short.TYPE.equals(clazz)) {
            return PayloadType.SHORT;
        }
        if (Integer.TYPE.equals(clazz)) {
            return PayloadType.INTEGER;
        }
        if (Double.TYPE.equals(clazz)) {
            return PayloadType.DOUBLE;
        }
        if (Float.TYPE.equals(clazz)) {
            return PayloadType.FLOAT;
        }
        if (Long.TYPE.equals(clazz)) {
            return PayloadType.LONG;
        }
        if (Character.TYPE.equals(clazz)) {
            return PayloadType.CHARACTER;
        }
        if (Boolean.TYPE.equals(clazz)) {
            return PayloadType.BOOLEAN;
        }
        if (Byte.TYPE.equals(clazz)) {
            return PayloadType.BYTE;
        }
        throw new JmsGenerationException("Parameter type not supported: " + clazz);
    }
}

