/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.loader;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.binding.jms.loader.JmsLoaderHelper;
import org.fabric3.binding.jms.model.JmsBindingDefinition;
import org.fabric3.binding.jms.spi.common.AdministeredObjectDefinition;
import org.fabric3.binding.jms.spi.common.CacheLevel;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.CorrelationScheme;
import org.fabric3.binding.jms.spi.common.CreateOption;
import org.fabric3.binding.jms.spi.common.DeliveryMode;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.DestinationType;
import org.fabric3.binding.jms.spi.common.HeadersDefinition;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.common.JmsURIMetadata;
import org.fabric3.binding.jms.spi.common.OperationPropertiesDefinition;
import org.fabric3.binding.jms.spi.common.PropertyAwareObject;
import org.fabric3.binding.jms.spi.common.ResponseDefinition;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JmsBindingLoader
implements TypeLoader<JmsBindingDefinition> {
    private static final Set<String> ATTRIBUTES = new HashSet<String>();
    private LoaderHelper loaderHelper;

    public JmsBindingLoader(@Reference LoaderHelper loaderHelper) {
        this.loaderHelper = loaderHelper;
    }

    public JmsBindingDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        JmsBindingDefinition bd;
        JmsBindingMetadata metadata;
        this.validateAttributes(reader, context);
        String bindingName = reader.getAttributeValue(null, "name");
        String uri = reader.getAttributeValue(null, "uri");
        if (uri != null) {
            try {
                JmsURIMetadata uriMeta = JmsURIMetadata.parseURI(uri);
                metadata = JmsLoaderHelper.getJmsMetadataFromURI(uriMeta);
            }
            catch (URISyntaxException e) {
                InvalidValue failure = new InvalidValue("Invalid JMS binding URI: " + uri, reader, (Throwable)e);
                context.addError((ValidationFailure)failure);
                return null;
            }
            URI targetURI = null;
            try {
                targetURI = this.loaderHelper.parseUri(uri);
            }
            catch (URISyntaxException e) {
                InvalidValue error = new InvalidValue("Invalid JMS binding URI: " + targetURI, reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
            bd = new JmsBindingDefinition(bindingName, targetURI, metadata);
        } else {
            metadata = new JmsBindingMetadata();
            bd = new JmsBindingDefinition(bindingName, metadata);
        }
        NamespaceContext namespace = reader.getNamespaceContext();
        String targetNamespace = context.getTargetNamespace();
        String correlationScheme = reader.getAttributeValue(null, "correlationScheme");
        if (correlationScheme != null) {
            QName scheme = LoaderUtil.getQName((String)correlationScheme, (String)targetNamespace, (NamespaceContext)namespace);
            if ("messageID".equalsIgnoreCase(scheme.getLocalPart())) {
                metadata.setCorrelationScheme(CorrelationScheme.MESSAGE_ID);
            } else if ("correlationID".equalsIgnoreCase(scheme.getLocalPart())) {
                metadata.setCorrelationScheme(CorrelationScheme.CORRELATION_ID);
            } else if ("none".equalsIgnoreCase(scheme.getLocalPart())) {
                metadata.setCorrelationScheme(CorrelationScheme.NONE);
            } else {
                InvalidValue error = new InvalidValue("Invalid value specified for correlationScheme attribute: " + scheme.getLocalPart(), reader);
                context.addError((ValidationFailure)error);
            }
        }
        QName requestConnection = LoaderUtil.getQName((String)"requestConnection", (String)targetNamespace, (NamespaceContext)namespace);
        bd.setRequestConnection(requestConnection);
        QName responseConnection = LoaderUtil.getQName((String)"responseConnection", (String)targetNamespace, (NamespaceContext)namespace);
        bd.setResponseConnection(responseConnection);
        metadata.setJndiUrl(reader.getAttributeValue(null, "jndiURL"));
        metadata.setInitialContextFactory(reader.getAttributeValue(null, "initialContextFactory"));
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)bd, reader, context);
        if (uri != null) {
            while (2 != reader.next() || !"binding.jms".equals(reader.getName().getLocalPart())) {
            }
            return bd;
        }
        this.loadFabric3Attributes(metadata, reader, context);
        while (true) {
            switch (reader.next()) {
                case 1: {
                    Object destination;
                    String name = reader.getName().getLocalPart();
                    if ("destination".equals(name)) {
                        destination = this.loadDestination(reader, context);
                        metadata.setDestination((DestinationDefinition)((Object)destination));
                        break;
                    }
                    if ("connectionFactory".equals(name)) {
                        ConnectionFactoryDefinition connectionFactory = this.loadConnectionFactory(reader, context);
                        metadata.setConnectionFactory(connectionFactory);
                        break;
                    }
                    if ("response".equals(name)) {
                        ResponseDefinition response = this.loadResponse(reader, context);
                        metadata.setResponse(response);
                        break;
                    }
                    if ("headers".equals(name)) {
                        HeadersDefinition headers = this.loadHeaders(reader, context);
                        metadata.setHeaders(headers);
                        break;
                    }
                    if (!"operationProperties".equals(name)) break;
                    OperationPropertiesDefinition operationProperties = this.loadOperationProperties(reader, context);
                    metadata.addOperationProperties(operationProperties.getName(), operationProperties);
                    break;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if (!"binding.jms".equals(name)) break;
                    Object destination = bd.getJmsMetadata().getDestination().getName();
                    URI bindingUri = URI.create("jms:" + (String)destination);
                    bd.setGeneratedTargetUri(bindingUri);
                    return bd;
                }
            }
        }
    }

    private void loadFabric3Attributes(JmsBindingMetadata metadata, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        String min;
        String max;
        String recoveryInterval;
        String maxMessagesProcess;
        String responseTimeout;
        String receiveTimeout;
        String trxTimeout;
        String cacheLevel = reader.getAttributeValue(null, "cache");
        if (cacheLevel == null) {
            metadata.setCacheLevel(CacheLevel.NONE);
        } else if ("connection".equalsIgnoreCase(cacheLevel)) {
            metadata.setCacheLevel(CacheLevel.CONNECTION);
        } else if ("session".equalsIgnoreCase(cacheLevel)) {
            metadata.setCacheLevel(CacheLevel.SESSION);
        } else {
            InvalidValue error = new InvalidValue("Invalid cache level attribute", reader);
            context.addError((ValidationFailure)error);
        }
        String idleLimit = reader.getAttributeValue(null, "idle.limit");
        if (idleLimit != null) {
            try {
                int val = Integer.parseInt(idleLimit);
                metadata.setIdleLimit(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid idle.limit attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        if ((trxTimeout = reader.getAttributeValue(null, "transaction.timeout")) != null) {
            try {
                int val = Integer.parseInt(trxTimeout);
                metadata.setTransactionTimeout(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid transaction.timeout attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        if ((receiveTimeout = reader.getAttributeValue(null, "receive.timeout")) != null) {
            try {
                int val = Integer.parseInt(receiveTimeout);
                metadata.setReceiveTimeout(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid receive.timeout attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        if ((responseTimeout = reader.getAttributeValue(null, "response.timeout")) != null) {
            try {
                int val = Integer.parseInt(responseTimeout);
                metadata.setResponseTimeout(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid response.timeout attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        if ((maxMessagesProcess = reader.getAttributeValue(null, "max.messages")) != null) {
            try {
                int val = Integer.parseInt(maxMessagesProcess);
                metadata.setMaxMessagesToProcess(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid max.messages attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        if ((recoveryInterval = reader.getAttributeValue(null, "recovery.interval")) != null) {
            try {
                int val = Integer.parseInt(recoveryInterval);
                metadata.setRecoveryInterval(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid recovery.interval attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        if ((max = reader.getAttributeValue(null, "max.receivers")) != null) {
            try {
                int val = Integer.parseInt(max);
                metadata.setMaxReceivers(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid max.receivers attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        if ((min = reader.getAttributeValue(null, "min.receivers")) != null) {
            try {
                int val = Integer.parseInt(min);
                metadata.setMinReceivers(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid min.receivers attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
    }

    private ResponseDefinition loadResponse(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ResponseDefinition response = new ResponseDefinition();
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String name = reader.getName().getLocalPart();
                    if ("destination".equals(name)) {
                        DestinationDefinition destination = this.loadDestination(reader, context);
                        response.setDestination(destination);
                        break;
                    }
                    if (!"connectionFactory".equals(name)) break;
                    ConnectionFactoryDefinition connectionFactory = this.loadConnectionFactory(reader, context);
                    response.setConnectionFactory(connectionFactory);
                    break;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if (!"response".equals(name)) break;
                    return response;
                }
            }
        }
    }

    private ConnectionFactoryDefinition loadConnectionFactory(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ConnectionFactoryDefinition connectionFactory = new ConnectionFactoryDefinition();
        connectionFactory.setName(reader.getAttributeValue(null, "jndiName"));
        this.parseCreate(reader, context, connectionFactory);
        this.loadProperties(reader, connectionFactory, "connectionFactory");
        return connectionFactory;
    }

    private DestinationDefinition loadDestination(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        MissingAttribute error;
        DestinationDefinition destination = new DestinationDefinition();
        String jndiName = reader.getAttributeValue(null, "jndiName");
        if (jndiName != null) {
            destination.setName(jndiName);
        } else {
            String name = reader.getAttributeValue(null, "name");
            if (name == null) {
                error = new MissingAttribute("Destination must have either a jndiName or name attribute set", reader);
                context.addError((ValidationFailure)error);
            }
        }
        this.parseCreate(reader, context, destination);
        String type = reader.getAttributeValue(null, "type");
        if (type != null) {
            if ("queue".equalsIgnoreCase(type)) {
                destination.setType(DestinationType.QUEUE);
            } else if ("topic".equalsIgnoreCase(type)) {
                destination.setType(DestinationType.TOPIC);
            } else {
                error = new InvalidValue("Invalid value specified for destination type: " + type, reader);
                context.addError((ValidationFailure)error);
            }
        }
        this.loadProperties(reader, destination, "destination");
        return destination;
    }

    private void parseCreate(XMLStreamReader reader, IntrospectionContext context, AdministeredObjectDefinition definition) {
        String create = reader.getAttributeValue(null, "create");
        if (create != null) {
            if ("always".equals(create)) {
                definition.setCreate(CreateOption.ALWAYS);
            } else if ("never".equalsIgnoreCase(create)) {
                definition.setCreate(CreateOption.NEVER);
            } else if ("ifNotExist".equalsIgnoreCase(create)) {
                definition.setCreate(CreateOption.IF_NOT_EXIST);
            } else {
                InvalidValue error = new InvalidValue("Invalid value specified for create attribute: " + create, reader);
                context.addError((ValidationFailure)error);
            }
        }
    }

    private HeadersDefinition loadHeaders(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        String timeToLive;
        String priority;
        HeadersDefinition headers = new HeadersDefinition();
        String deliveryMode = reader.getAttributeValue(null, "deliveryMode");
        if (deliveryMode != null) {
            if ("PERSISTENT".equalsIgnoreCase(deliveryMode)) {
                headers.setDeliveryMode(DeliveryMode.PERSISTENT);
            } else if ("NONPERSISTENT".equalsIgnoreCase(deliveryMode)) {
                headers.setDeliveryMode(DeliveryMode.NONPERSISTENT);
            } else {
                InvalidValue failure = new InvalidValue("Invalid delivery mode: " + deliveryMode, reader);
                context.addError((ValidationFailure)failure);
            }
        }
        if ((priority = reader.getAttributeValue(null, "priority")) != null) {
            try {
                headers.setPriority(Integer.valueOf(priority));
            }
            catch (NumberFormatException nfe) {
                InvalidValue failure = new InvalidValue("Invalid priority: " + priority, reader, (Throwable)nfe);
                context.addError((ValidationFailure)failure);
            }
        }
        if ((timeToLive = reader.getAttributeValue(null, "timeToLive")) != null) {
            try {
                headers.setTimeToLive(Long.valueOf(timeToLive));
            }
            catch (NumberFormatException nfe) {
                InvalidValue failure = new InvalidValue("Invalid time-to-live value: " + timeToLive, reader, (Throwable)nfe);
                context.addError((ValidationFailure)failure);
            }
        }
        headers.setType(reader.getAttributeValue(null, "type"));
        this.loadProperties(reader, headers, "headers");
        return headers;
    }

    private OperationPropertiesDefinition loadOperationProperties(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        OperationPropertiesDefinition optProperties = new OperationPropertiesDefinition();
        optProperties.setName(reader.getAttributeValue(null, "name"));
        optProperties.setNativeOperation(reader.getAttributeValue(null, "nativeOperation"));
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String name = reader.getName().getLocalPart();
                    if ("headers".equals(name)) {
                        HeadersDefinition headersDefinition = this.loadHeaders(reader, context);
                        optProperties.setHeaders(headersDefinition);
                        break;
                    }
                    if (!"property".equals(name)) break;
                    this.loadProperty(reader, optProperties);
                    break;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if (!"operationProperties".equals(name)) break;
                    return optProperties;
                }
            }
        }
    }

    private void loadProperties(XMLStreamReader reader, PropertyAwareObject parent, String parentName) throws XMLStreamException {
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String name = reader.getName().getLocalPart();
                    if (!"property".equals(name)) break;
                    this.loadProperty(reader, parent);
                    break;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if (!parentName.equals(name)) break;
                    return;
                }
            }
        }
    }

    private void loadProperty(XMLStreamReader reader, PropertyAwareObject parent) throws XMLStreamException {
        String key = reader.getAttributeValue(null, "name");
        String value = reader.getElementText();
        parent.addProperty(key, value);
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if (ATTRIBUTES.contains(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }

    static {
        ATTRIBUTES.add("uri");
        ATTRIBUTES.add("correlationScheme");
        ATTRIBUTES.add("jndiURL");
        ATTRIBUTES.add("initialContextFactory");
        ATTRIBUTES.add("requires");
        ATTRIBUTES.add("policySets");
        ATTRIBUTES.add("create");
        ATTRIBUTES.add("type");
        ATTRIBUTES.add("destination");
        ATTRIBUTES.add("connectionFactory");
        ATTRIBUTES.add("type");
        ATTRIBUTES.add("timeToLive");
        ATTRIBUTES.add("priority");
        ATTRIBUTES.add("deliveryMode");
        ATTRIBUTES.add("correlationScheme");
        ATTRIBUTES.add("name");
        ATTRIBUTES.add("requestConnection");
        ATTRIBUTES.add("responseConnection");
        ATTRIBUTES.add("cache");
        ATTRIBUTES.add("idle.limit");
        ATTRIBUTES.add("transaction.timeout");
        ATTRIBUTES.add("receive.timeout");
        ATTRIBUTES.add("response.timeout");
        ATTRIBUTES.add("max.messages");
        ATTRIBUTES.add("recovery.interval");
        ATTRIBUTES.add("max.receivers");
        ATTRIBUTES.add("min.receivers");
    }
}

