/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.loader;

import java.util.Map;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.CreateOption;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.DestinationType;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.common.JmsURIMetadata;
import org.fabric3.binding.jms.spi.common.ResponseDefinition;

public class JmsLoaderHelper {
    private JmsLoaderHelper() {
    }

    static JmsBindingMetadata getJmsMetadataFromURI(JmsURIMetadata metadata) {
        JmsBindingMetadata result = new JmsBindingMetadata();
        Map<String, String> uriProperties = metadata.getProperties();
        DestinationDefinition destination = new DestinationDefinition();
        String destinationType = uriProperties.get("destinationType");
        if ("topic".equalsIgnoreCase(destinationType)) {
            destination.setType(DestinationType.TOPIC);
        }
        destination.setName(metadata.getDestination());
        destination.setCreate(CreateOption.NEVER);
        result.setDestination(destination);
        ConnectionFactoryDefinition connectionFactory = new ConnectionFactoryDefinition();
        String connectionFactoryName = uriProperties.get("connectionFactoryName");
        connectionFactory.setName(connectionFactoryName);
        connectionFactory.setCreate(CreateOption.NEVER);
        result.setConnectionFactory(connectionFactory);
        ResponseDefinition response = new ResponseDefinition();
        response.setConnectionFactory(connectionFactory);
        DestinationDefinition responseDestinationDef = new DestinationDefinition();
        String responseDestination = uriProperties.get("responseDestination");
        responseDestinationDef.setName(responseDestination);
        responseDestinationDef.setCreate(CreateOption.NEVER);
        response.setDestination(responseDestinationDef);
        result.setResponse(response);
        return result;
    }
}

