/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.fabric3.binding.jms.runtime.ListenerMonitor;
import org.fabric3.spi.channel.EventStreamHandler;

public class EventStreamListener
implements MessageListener {
    private ClassLoader cl;
    private ListenerMonitor monitor;
    private EventStreamHandler handler;

    public EventStreamListener(ClassLoader cl, EventStreamHandler handler, ListenerMonitor monitor) {
        this.cl = cl;
        this.handler = handler;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message request) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.cl);
            if (!(request instanceof ObjectMessage)) {
                String type = request.getClass().getName();
                this.monitor.errorMessage("Message is an invalid type. Since the message is invalid, redelivery will not be attempted:" + type);
                return;
            }
            ObjectMessage message = (ObjectMessage)request;
            this.handler.handle((Object)message.getObject());
        }
        catch (JMSException e) {
            this.monitor.error("Error processing message. Redelivery will not be attempted", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

